/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.informer;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.sergeych.informer.LostEvent;
import net.sergeych.informer.Subscriber;
import net.sergeych.utils.LogPrinter;

public class Informer {
    static LogPrinter log = new LogPrinter("");
    private ExceptionListener exceptionListener = null;
    private WeakHashMap<Object, ArrayList<SubInvocation>> weakInvocations = new WeakHashMap();
    private HashMap<Object, ArrayList<SubInvocation>> strongInvocations = new HashMap();

    public Informer() {
    }

    public Informer(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public void post(Object event) {
        int processedCount = this.invokeCollection(this.weakInvocations, event);
        if ((processedCount += this.invokeCollection(this.strongInvocations, event)) == 0 && !(event instanceof LostEvent)) {
            this.post(new LostEvent(event));
        }
    }

    private int invokeCollection(Map<Object, ArrayList<SubInvocation>> collection, Object event) {
        int processedCount = 0;
        block0: for (ArrayList<SubInvocation> list : collection.values()) {
            for (SubInvocation si : list) {
                Result result = si.invokeIfMatch(event);
                if (result == Result.NO_MATCH) continue;
                ++processedCount;
                if (result != Result.CONSUMED) continue;
                continue block0;
            }
        }
        return processedCount;
    }

    public void postAfter(final Object event, final long millis) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(millis);
                    Informer.this.post(event);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void registerWeak(Object subscriber) {
        this.register(subscriber, true);
    }

    public void registerStrong(Object subscriber) {
        this.register(subscriber, false);
    }

    public boolean unregister(Object subscriber) {
        boolean found = this.weakInvocations.remove(subscriber) != null;
        found = found || this.strongInvocations.remove(subscriber) != null;
        return found;
    }

    public void register(Object subscriber, boolean registerWeak) {
        this.unregister(subscriber);
        AbstractMap map = registerWeak ? this.weakInvocations : this.strongInvocations;
        for (Method m : subscriber.getClass().getMethods()) {
            if (!m.isAnnotationPresent(Subscriber.class)) continue;
            SubInvocation si = new SubInvocation(subscriber, m);
            ArrayList<SubInvocation> ii = (ArrayList<SubInvocation>)map.get(subscriber);
            if (ii == null) {
                ii = new ArrayList<SubInvocation>();
                map.put(subscriber, ii);
            }
            ii.add(si);
        }
    }

    private class SubInvocation {
        private Class eventClass;
        private boolean canConsume = false;
        private Method method;
        private WeakReference<Object> weakObject;

        SubInvocation(Object object, Method method) {
            this.method = method;
            this.weakObject = new WeakReference<Object>(object);
            Class<?>[] pt = method.getParameterTypes();
            if (pt.length != 1) {
                throw new IllegalArgumentException("@Subscriber must take only one parameter");
            }
            this.eventClass = pt[0];
            if (method.getReturnType().getCanonicalName().equals("boolean")) {
                this.canConsume = true;
            }
        }

        Result invokeIfMatch(Object parameter) {
            block5: {
                if (this.eventClass.isInstance(parameter)) {
                    Object receiver = this.weakObject.get();
                    try {
                        if (receiver != null) {
                            Object result = this.method.invoke(receiver, parameter);
                            return this.canConsume && (Boolean)result != false ? Result.CONSUMED : Result.PROCESSED;
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalAccessException) {
                            throw new RuntimeException("Informer has no access to subscriber", e);
                        }
                        if (Informer.this.exceptionListener == null) break block5;
                        Informer.this.exceptionListener.onSubscriberException(new ExceptionContext(this, e));
                    }
                }
            }
            return Result.NO_MATCH;
        }
    }

    static enum Result {
        NO_MATCH,
        PROCESSED,
        CONSUMED;

    }

    public static interface ExceptionListener {
        public void onSubscriberException(ExceptionContext var1);
    }

    public class ExceptionContext {
        SubInvocation si;
        private Method method;
        private Object subscriber;
        private Exception exception;

        public Informer getInformer() {
            return Informer.this;
        }

        public Method getMethod() {
            return this.si.method;
        }

        public Object getSubscriber() {
            return this.si.weakObject.get();
        }

        public Exception getException() {
            return this.exception;
        }

        private ExceptionContext(SubInvocation invocation, Exception e) {
            this.exception = e;
            this.si = invocation;
        }
    }
}

