/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.map_serializer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sergeych.map_serializer.SerialName;
import net.sergeych.tools.Binder;

public class MapSerializer {
    public HashMap<String, Class<?>> classAliases = new HashMap();

    private static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(MapSerializer.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(MapSerializer.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public void registerPackage(String packageName) throws CantProcessException {
        try {
            Class<?>[] cc;
            for (Class<?> c : cc = MapSerializer.getClasses(packageName)) {
                SerialName sn = c.getAnnotation(SerialName.class);
                if (sn == null) continue;
                this.classAliases.put(sn.name(), c);
            }
        }
        catch (Exception e) {
            this.logicError(e);
        }
    }

    public void addClassAlias(Class<?> cls, String alias) {
        this.classAliases.put(alias, cls);
    }

    public Binder toMap(Object object, boolean includeClass) throws CantProcessException {
        Binder map = new Binder();
        Class<?> cls = object.getClass();
        for (Field f : cls.getDeclaredFields()) {
            int mods = f.getModifiers();
            if (!Modifier.isTransient(mods)) {
                try {
                    f.setAccessible(true);
                    SerialName sn = f.getAnnotation(SerialName.class);
                    map.put(sn == null ? MapSerializer.camelToSnakeCase(f.getName()) : sn.name(), f.get(object));
                }
                catch (Exception e) {
                    this.logicError(e);
                }
            }
            if (!includeClass) continue;
            map.put("__class", this.className(cls));
        }
        return map;
    }

    protected String className(Class<?> cls) {
        SerialName sn = cls.getAnnotation(SerialName.class);
        if (sn != null) {
            return sn.name();
        }
        return cls.getName();
    }

    protected Class<?> classForName(String name) throws ClassNotFoundException {
        Class<?> cls = this.classAliases.get(name);
        return cls != null ? cls : Class.forName(name);
    }

    public Object fromMap(Map<String, Object> map) throws CantProcessException {
        HashMap<String, Object> m = new HashMap<String, Object>(map);
        String className = (String)m.remove("__class");
        if (className == null) {
            throw new CantProcessException("No class type information to restore");
        }
        return this.fromMap(m, className);
    }

    public Object fromMap(Map<String, Object> map, String className) throws CantProcessException {
        try {
            return this.fromMap(map, this.classForName(className));
        }
        catch (Exception e) {
            this.logicError(e);
            return null;
        }
    }

    public <T> T fromMap(Map<String, Object> map, Class<T> cls) throws CantProcessException {
        try {
            return this.setInstance(map, cls.newInstance());
        }
        catch (Exception e) {
            this.logicError(e);
            return null;
        }
    }

    public <T> T setInstance(Map<String, Object> map, T object) throws CantProcessException {
        for (Field f : object.getClass().getDeclaredFields()) {
            int mods = f.getModifiers();
            if (Modifier.isTransient(mods)) continue;
            try {
                f.setAccessible(true);
                SerialName sn = f.getAnnotation(SerialName.class);
                Object value = map.get(sn == null ? MapSerializer.camelToSnakeCase(f.getName()) : sn.name());
                if (value == null) continue;
                Type type = f.getGenericType();
                if (type == String.class) {
                    value = value.toString();
                } else if (type == Date.class) {
                    if (value instanceof Number) {
                        value = new Date(((Number)value).longValue() * 1000L);
                    }
                } else if (value instanceof Object[] && Collection.class.isAssignableFrom(f.getType())) {
                    Collection coll = (Collection)f.getType().newInstance();
                    for (Object x : (Object[])value) {
                        coll.add(x);
                    }
                    value = coll;
                }
                f.set(object, value);
            }
            catch (Exception e) {
                this.logicError(e);
            }
        }
        return object;
    }

    protected void logicError(Exception e) throws CantProcessException {
        e.printStackTrace();
        throw new CantProcessException(e);
    }

    public static String snakeToCamelCase(String snake) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String oneString : snake.split("_")) {
            if (first) {
                sb.append(oneString.toLowerCase(Locale.US));
                first = false;
                continue;
            }
            sb.append(oneString.substring(0, 1).toUpperCase(Locale.US));
            sb.append(oneString.substring(1).toLowerCase(Locale.US));
        }
        return sb.toString();
    }

    public static String camelToSnakeCase(String camel) {
        StringBuilder sb = new StringBuilder();
        for (char c : camel.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append('_');
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public class CantProcessException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public CantProcessException(Exception inner) {
            super(inner);
        }

        public CantProcessException(String reason) {
            super(reason);
        }
    }
}

