/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.recordsfile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.tools.Binder;
import net.sergeych.utils.Bytes;

public class StructureDescriptor {
    private Map<String, FieldDef> fields = new HashMap<String, FieldDef>();
    private int currentOffset = 0;
    private boolean frozen = false;

    public int getSize() {
        return this.currentOffset;
    }

    public Binder unpack(byte[] res) {
        return this.unpack(res, 0);
    }

    public Binder unpack(byte[] data, int fromOffset) {
        Binder result = new Binder();
        this.fields.forEach((key, fd) -> result.put(key, fd.unpack(data, fromOffset)));
        return result;
    }

    public StructureDescriptor addField(String name, int sizeInBytes) {
        return this.addField(name, sizeInBytes, Integer.class);
    }

    public StructureDescriptor addField(String name, int sizeInBytes, Class itemClass) {
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("field already defined: " + name);
        }
        if (this.frozen) {
            throw new IllegalStateException("structure us frozen");
        }
        this.fields.put(name, new FieldDef(this.currentOffset, sizeInBytes, name, itemClass, 0));
        this.currentOffset += sizeInBytes;
        return this;
    }

    private StructureDescriptor addArrayField(String name, int itemSizeInBytes, int nEntries, Class itemClass) {
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("field already defined: " + name);
        }
        if (this.frozen) {
            throw new IllegalStateException("structure us frozen");
        }
        FieldDef fd = new FieldDef(this.currentOffset, itemSizeInBytes, name, itemClass, nEntries);
        this.fields.put(name, fd);
        this.currentOffset += fd.getSize();
        return this;
    }

    public byte[] pack(Binder data) {
        return this.pack(data, false);
    }

    public byte[] pack(Binder data, boolean ignoreNonFields) {
        this.frozen = true;
        byte[] bytes = new byte[this.currentOffset];
        this.packTo(bytes, 0, data, ignoreNonFields);
        return bytes;
    }

    public void packTo(byte[] bytes, int fromOffset, Binder data, boolean ignoreNonFields) {
        data.forEach((key, value) -> {
            FieldDef fd = this.fields.get(key);
            if (fd == null) {
                if (!ignoreNonFields) {
                    throw new IllegalArgumentException("undefined field: " + key);
                }
            } else {
                fd.pack(bytes, value, fromOffset);
            }
        });
    }

    public StructureDescriptor addByteField(String name) {
        return this.addField(name, 1);
    }

    public StructureDescriptor addShortField(String name) {
        return this.addField(name, 2);
    }

    public StructureDescriptor addIntField(String name) {
        return this.addField(name, 4);
    }

    public StructureDescriptor addLongField(String name) {
        return this.addField(name, 8, Long.class);
    }

    public StructureDescriptor addBinaryField(String name, int length) {
        return this.addArrayField(name, 1, length, Byte.class);
    }

    public StructureDescriptor addStringField(String name, int fieldSize) {
        return this.addArrayField(name, 1, fieldSize, String.class);
    }

    private class FieldDef {
        private final int offset;
        private final int size;
        private final String name;
        private Class valueClass;
        private int arrayLength;

        private FieldDef(int offset, int size, String name, Class valueClass, int arrayLength) {
            this.offset = offset;
            this.size = arrayLength > 0 ? size * arrayLength : size;
            this.arrayLength = arrayLength;
            this.name = name;
            this.valueClass = valueClass;
        }

        public void pack(byte[] data, Object value, int fromOffset) {
            if (value instanceof Bytes) {
                value = ((Bytes)value).toArray();
            }
            if (value instanceof byte[]) {
                this.packBinary(data, (byte[])value, fromOffset);
            } else if (value instanceof String) {
                this.packString(data, (String)value, fromOffset);
            } else {
                this.packAsInteger(data, value, fromOffset);
            }
        }

        private void packString(byte[] data, String value, int fromOffset) {
            String s = value;
            if (this.size != this.arrayLength) {
                throw new IllegalArgumentException("strigns require byte[] binary array to store");
            }
            int counterSize = this.getCounterSize();
            byte[] chars = s.getBytes();
            if (chars.length + counterSize > this.size) {
                throw new IllegalArgumentException("string too long");
            }
            int start = fromOffset + this.offset;
            this.packInt(data, start, chars.length, counterSize);
            System.arraycopy(chars, 0, data, start + counterSize, chars.length);
        }

        private int getCounterSize() {
            if (this.size <= 256) {
                return 1;
            }
            if (this.size <= 65533) {
                return 2;
            }
            return 3;
        }

        private void packBinary(byte[] data, byte[] value, int fromOffset) {
            byte[] bytes = value;
            if (this.size != bytes.length) {
                throw new IllegalArgumentException("field size mismatch: required " + this.size + " given " + bytes.length);
            }
            if (this.arrayLength != this.size) {
                throw new RuntimeException("binary field array length is wrong");
            }
            System.arraycopy(bytes, 0, data, this.offset + fromOffset, this.size);
        }

        private void packAsInteger(byte[] data, Object value, int fromOffset) {
            long acc;
            if (value instanceof Float || value instanceof Double) {
                throw new IllegalArgumentException("packing floats is not yet supported");
            }
            if (value instanceof Number) {
                acc = ((Number)value).longValue();
            } else if (value instanceof Character) {
                acc = ((Character)value).charValue();
            } else if (value instanceof Boolean) {
                acc = ((Integer)value).intValue();
            } else {
                throw new IllegalArgumentException("unsupported numeric type: " + value.getClass().getCanonicalName());
            }
            this.packInt(data, this.offset + fromOffset, acc, this.size);
        }

        private void packInt(byte[] data, int fromOffset, long value, int sizeInBytes) {
            long was = value;
            for (int i = 0; i < sizeInBytes; ++i) {
                data[fromOffset + sizeInBytes - i - 1] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        }

        public <T> T unpack(byte[] data, int fromOffset) {
            if (this.arrayLength > 0) {
                return (T)(String.class.isAssignableFrom(this.valueClass) ? this.unpackSring(data, fromOffset) : this.unpackArray(data, fromOffset));
            }
            if (this.valueClass.isArray()) {
                throw new RuntimeException("value class does not match array flag");
            }
            long val = this.unpackLong(data, fromOffset);
            if (this.valueClass == Integer.class) {
                return (T)new Integer((int)(val & 0xFFFFFFFFFFFFFFFFL));
            }
            if (this.valueClass == Byte.class) {
                return (T)new Byte((byte)(val & 0xFFL));
            }
            if (this.valueClass == Short.class) {
                return (T)new Short((short)(val & 0xFFFFL));
            }
            if (this.valueClass == Long.class) {
                return (T)new Long(val);
            }
            throw new IllegalArgumentException("can't unpack type: " + this.valueClass.getCanonicalName());
        }

        private String unpackSring(byte[] data, int fromOffset) {
            int counterSize = this.getCounterSize();
            int length = (int)this.readIntegerFrom(data, this.offset + fromOffset, counterSize);
            int start = this.offset + fromOffset + counterSize;
            byte[] stringBytes = Arrays.copyOfRange(data, start, start + length);
            return new String(stringBytes);
        }

        private <T> T unpackArray(byte[] data, int fromOffset) {
            if (this.arrayLength != this.size) {
                throw new RuntimeException("only byte arrays are yet supported");
            }
            int start = this.offset + fromOffset;
            return (T)Arrays.copyOfRange(data, start, start + this.arrayLength);
        }

        private long unpackLong(byte[] data, int fromOffset) {
            return this.readIntegerFrom(data, fromOffset + this.offset, this.size);
        }

        private long readIntegerFrom(byte[] data, int fromOffset, int sizeInBytes) {
            long acc = 0L;
            for (int i = 0; i < sizeInBytes; ++i) {
                acc = acc << 8 | (long)(data[this.offset + i] & 0xFF);
            }
            return acc;
        }

        public int getSize() {
            return this.size;
        }
    }
}

