/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class AsyncEvent<T> {
    private T result;
    private boolean fired = false;
    private Object mutex = new Object();
    private List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();
    private static ExecutorService pool = Executors.newCachedThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEvent<T> addConsumer(Consumer<T> consumer) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.fired) {
                pool.execute(() -> consumer.accept(this.result));
            } else {
                this.consumers.add(consumer);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(T result) {
        Object object = this.mutex;
        synchronized (object) {
            this.result = result;
            this.fired = true;
            for (Consumer consumer : this.consumers) {
                pool.execute(() -> consumer.accept(result));
            }
            this.consumers.clear();
            this.mutex.notifyAll();
        }
    }

    public boolean isFired() {
        return this.fired;
    }

    @Deprecated
    public T waitFired() throws InterruptedException {
        return this.await();
    }

    public T await() throws InterruptedException {
        try {
            return this.await(0L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("impossible: timeout can't be expired with 0 wait time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T await(long milliseconds) throws TimeoutException, InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.fired) {
                this.mutex.wait(milliseconds);
                if (!this.fired) {
                    throw new TimeoutException();
                }
            }
        }
        return this.result;
    }

    public final void fire() {
        this.fire(null);
    }
}

