/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

public class Average {
    private double sum = 0.0;
    private double sum2 = 0.0;
    private long n = 0L;

    public synchronized long update(double value) {
        this.sum += value;
        this.sum2 += value * value;
        return ++this.n;
    }

    public double average() {
        if (this.n < 1L) {
            throw new IllegalStateException("too few samples");
        }
        return this.sum / (double)this.n;
    }

    public double stdev2() {
        double m = this.average();
        return this.sum2 / (double)this.n - m * m;
    }

    public double stdev() {
        return Math.sqrt(this.stdev2());
    }

    public long length() {
        return this.n;
    }

    public double correctedStdev() {
        long n = this.length();
        if (n < 2L) {
            throw new IllegalStateException("too few samples");
        }
        return this.stdev() * Math.sqrt((double)n / (double)(n - 1L));
    }

    public String toString() {
        return "" + this.average() + "\u00b1" + this.stdev();
    }

    public double variation() {
        return this.stdev() / this.average();
    }
}

