/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Do;
import net.sergeych.utils.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Binder
extends HashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Binder EMPTY = new Binder();
    private boolean frozen = false;

    public static Binder fromKeysValues(Object ... args) {
        Binder map = new Binder();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i].toString(), args[i + 1]);
        }
        return map;
    }

    public Binder(Map copyFrom) {
        this.putAll(copyFrom);
    }

    public Binder() {
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    protected void checkNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("attempt to modify a frozen binder");
        }
    }

    public Binder(Object ... keyValuePairs) {
        this.putAll(keyValuePairs);
    }

    public Double getDouble(String key) {
        Object x = this.get(key);
        if (x instanceof String) {
            return Double.parseDouble((String)x);
        }
        return new Double((Double)x);
    }

    public String getStringOrThrow(String key) throws IllegalArgumentException {
        Object object = this.get(key);
        if (object == null) {
            throw new IllegalArgumentException("missing required parameter: " + key);
        }
        return object.toString();
    }

    public String getString(String key, String defaultValue) {
        Object result = this.get(key);
        return result == null ? defaultValue : result.toString();
    }

    public String getString(String key) throws IllegalArgumentException {
        return this.getStringOrThrow(key);
    }

    public byte[] getBinary(String key) {
        Object x = this.get(key);
        if (x == null) {
            return null;
        }
        if (x instanceof Bytes) {
            return ((Bytes)x).toArray();
        }
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof Map) {
            if ((x = DefaultBiMapper.deserialize((Map)x)) instanceof Bytes) {
                return ((Bytes)x).toArray();
            }
            if (x instanceof byte[]) {
                return (byte[])x;
            }
        }
        if (x instanceof String) {
            char[] cc = ((String)x).toCharArray();
            byte[] bb = new byte[cc.length];
            for (int i = 0; i < cc.length; ++i) {
                bb[i] = (byte)(cc[i] & 0xFF);
            }
            return bb;
        }
        throw new ClassCastException("parameter can't be converted to byte[]");
    }

    public @NonNull byte[] getBinaryOrThrow(String key) throws IllegalArgumentException {
        byte[] binary = this.getBinary(key);
        if (binary == null) {
            throw new IllegalArgumentException("missing required parameter: " + key);
        }
        return binary;
    }

    @Deprecated
    public boolean getBoolean(String key) {
        Boolean res = (Boolean)this.get(key);
        return res == null ? false : res;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean res = (Boolean)this.get(key);
        return res == null ? defaultValue : res;
    }

    public Boolean getBooleanOrThrow(String key) throws IllegalArgumentException {
        Boolean result = this.getBoolean(key, null);
        if (result == null) {
            throw new IllegalArgumentException("missing key " + key);
        }
        return result;
    }

    @Deprecated
    public Binder of(String key) {
        HashMap x = (HashMap)this.get(key);
        Binder b = null;
        if (x instanceof Binder) {
            b = (Binder)x;
        } else {
            Binder binder = b = x != null ? new Binder((Map)x) : new Binder();
        }
        if (this.frozen) {
            b.freeze();
        }
        return b;
    }

    public static Binder of(String key, Object value, Object ... keysValues) {
        Binder b = Binder.fromKeysValues(keysValues);
        b.put(key, value);
        return b;
    }

    public Binder getOrCreateBinder(String key) {
        this.checkNotFrozen();
        HashMap x = (HashMap)this.get(key);
        Binder b = null;
        if (x == null) {
            b = new Binder();
            this.put(key, b);
        } else {
            b = x instanceof Binder ? (Binder)x : new Binder((Map)x);
        }
        return b;
    }

    public Binder getBinder(String key) {
        return this.of(key);
    }

    public Binder getBinderOrThrow(String key) {
        Binder result = this.getBinder(key, null);
        if (result == null) {
            throw new IllegalArgumentException("map not found at key: " + key);
        }
        return result;
    }

    public Binder getBinder(String key, Binder defaultValue) {
        HashMap x = (HashMap)this.get(key);
        Binder b = null;
        if (x instanceof Binder) {
            b = (Binder)x;
        } else if (x != null) {
            b = new Binder((Map)x);
            if (this.frozen) {
                b.freeze();
            }
        }
        return b == null ? defaultValue : b;
    }

    @Deprecated
    public int getInt(String key) {
        return this.getIntOrThrow(key);
    }

    public int getIntOrThrow(String key) {
        Number n;
        Object x = this.get(key);
        Number number = n = x instanceof Number ? (Number)((Number)x) : (Number)Integer.valueOf((String)x);
        if (n == null) {
            throw new IllegalArgumentException("missing integer parameter");
        }
        return n.intValue();
    }

    @Deprecated
    public long getLong(String key) {
        Number i = (Number)this.get(key);
        if (i == null) {
            throw new IllegalArgumentException("missing long integer parameter");
        }
        return i.longValue();
    }

    public long getLong(String key, long defaultValue) {
        Number i = (Number)this.get(key);
        return i == null ? defaultValue : i.longValue();
    }

    public Integer getInt(String key, Integer defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return Integer.valueOf((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new IllegalArgumentException("can't convert to integer: " + o.getClass().getCanonicalName());
    }

    public ArrayList<?> getArray(String key) {
        Object x = this.get(key);
        return x == null ? new ArrayList() : Do.list(x);
    }

    public ArrayList<Binder> getBinders(String key) {
        Object o = this.get(key);
        if (o instanceof ArrayList) {
            return (ArrayList)o;
        }
        ArrayList<Binder> result = new ArrayList<Binder>();
        for (Object x : this.getArray(key)) {
            if (x instanceof Binder) {
                result.add((Binder)x);
                continue;
            }
            result.add(new Binder((Map)x));
        }
        return result;
    }

    public <T> T set(String key, T object) {
        this.checkNotFrozen();
        this.put(key, object);
        return object;
    }

    public Binder unmodifiableCopy() {
        Binder b = new Binder((Map)this);
        b.freeze();
        return b;
    }

    public void freeze() {
        this.frozen = true;
    }

    public static Binder from(Object x) {
        if (x instanceof Binder) {
            return (Binder)x;
        }
        return new Binder((Map)x);
    }

    public static <T> T convertAllMapsToBinders(Object object) {
        if (object != null) {
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, Binder.convertAllMapsToBinders(list.get(i)));
                }
            }
            if (object instanceof Map) {
                object = Binder.from(object);
                Map map = (Map)object;
                for (Object key : map.keySet()) {
                    map.replace(key, Binder.convertAllMapsToBinders(map.get(key)));
                }
            }
        }
        return (T)object;
    }

    public static Binder of(Object x) {
        return Binder.from(x);
    }

    public Binder putAll(Object ... keyValueParis) {
        if ((keyValueParis.length & 1) == 1) {
            throw new IllegalArgumentException("keyValuePairs should be even sized array");
        }
        for (int i = 0; i < keyValueParis.length; i += 2) {
            String key = keyValueParis[i].toString();
            this.put(key, keyValueParis[i + 1]);
        }
        return this;
    }

    public ZonedDateTime getZonedDateTime(String key, ZonedDateTime defaultValue) {
        Object obj = this.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof ZonedDateTime) {
            return (ZonedDateTime)obj;
        }
        if (obj instanceof Date) {
            return ZonedDateTime.ofInstant(((Date)obj).toInstant(), ZoneId.systemDefault());
        }
        if (obj instanceof Number) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Number)obj).longValue()), ZoneId.systemDefault());
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            String t = (String)map.get("__type");
            if (t == null) {
                t = (String)map.get("__t");
            }
            long ss = ((Number)map.get("seconds")).longValue();
            if (t != null) {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(ss), ZoneId.systemDefault());
            }
        }
        if (obj.equals("now()")) {
            return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        }
        throw new IllegalArgumentException("can't convert key " + key + " to ZonedDateTime: " + obj);
    }

    public ZonedDateTime getZonedDateTimeOrThrow(String key) {
        ZonedDateTime t = this.getZonedDateTime(key, null);
        if (t == null) {
            throw new IllegalArgumentException("missing key:" + key);
        }
        return t;
    }

    public long getLongOrThrow(String key) {
        Number n;
        Object x = this.get(key);
        Number number = n = x instanceof Number ? (Number)((Number)x) : (Number)Long.valueOf((String)x);
        if (n == null) {
            throw new IllegalArgumentException("missing long integer parameter: " + key);
        }
        return n.longValue();
    }

    public Bytes getBytesOrThrow(String key) {
        Bytes bb = this.getBytes(key, null);
        if (bb == null) {
            throw new IllegalArgumentException("missing reauired Bytes parameter: " + key);
        }
        return bb;
    }

    private Bytes getBytes(String key, Bytes defaultValue) {
        Object x = this.get(key);
        if (x instanceof Bytes) {
            return (Bytes)x;
        }
        if (x instanceof byte[]) {
            return new Bytes(new byte[][]{(byte[])x});
        }
        throw new IllegalArgumentException("can't convert to Bytes: " + x);
    }

    public <T> T getOrThrow(String key) {
        Object result = this.get(key);
        if (result == null) {
            throw new IllegalArgumentException("missing key: " + key);
        }
        return (T)result;
    }

    public <T> List<T> getOrCreateList(String key) {
        Object x = this.get(key);
        if (x == null) {
            return new ArrayList();
        }
        return Do.list(x);
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        Object x = this.get(key);
        if (x == null) {
            return defaultValue;
        }
        return Do.list(x);
    }

    public List getListOrThrow(String key) {
        List list = this.getList(key, null);
        if (list == null) {
            throw new IllegalArgumentException("missing list parameter: " + key);
        }
        return list;
    }

    public int addToInt(String name, int delta) {
        int value = this.getIntOrThrow(name);
        this.put(name, value += delta);
        return value;
    }

    public Binder getBinderOrThrow(String ... path) {
        Binder b = this;
        for (String p : path) {
            b = b.getBinderOrThrow(p);
        }
        return b;
    }

    public String getStringOrThrow(String ... path) {
        return this.getBinderPathOrThrow(path).getStringOrThrow(path[path.length - 1]);
    }

    private Binder getBinderPathOrThrow(String[] path) {
        Binder b = this;
        for (int i = 0; i < path.length - 1; ++i) {
            b = b.getBinderOrThrow(path[i]);
        }
        return b;
    }

    public <T> T getOrThrow(String ... path) {
        return this.getBinderPathOrThrow(path).getOrThrow(path[path.length - 1]);
    }

    public <T> T getOrNull(String ... path) {
        return (T)this.getBinderPathOrThrow(path).get(path[path.length - 1]);
    }

    static {
        EMPTY.freeze();
    }
}

