/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.sergeych.biserializer.BiAdapter;
import net.sergeych.biserializer.BiDeserializer;
import net.sergeych.biserializer.BiSerializer;
import net.sergeych.biserializer.DefaultBiMapper;
import net.sergeych.tools.Binder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BufferedLogger
implements AutoCloseable {
    private Thread loggerThread;
    private Thread interceptorThread;
    private PipedInputStream inPipe;
    private boolean printTimestamp = false;
    static DateTimeFormatter fmt = DateTimeFormatter.ISO_INSTANT;
    private PrintStream printStream;
    private int maxLines;
    private final LinkedList<Entry> buffer = new LinkedList();
    private PrintStream pstream = null;
    private final BlockingQueue<Entry> queue = new LinkedBlockingQueue<Entry>();
    private final Object queueEmpty = new Object();
    private AtomicBoolean consoleIntercepted = new AtomicBoolean(false);
    private PrintStream oldOut = null;

    public void e(String s) {
        this.log("ERROR: " + s);
    }

    public BufferedLogger(int maxEntries) {
        this.maxLines = maxEntries;
        this.loggerThread = new Thread(() -> {
            while (true) {
                LinkedList<Entry> linkedList;
                Entry entry = null;
                if (this.queue.size() == 0) {
                    linkedList = this.queueEmpty;
                    synchronized (linkedList) {
                        this.queueEmpty.notifyAll();
                    }
                }
                try {
                    entry = this.queue.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                linkedList = this.buffer;
                synchronized (linkedList) {
                    this.buffer.add(entry);
                    while (this.buffer.size() > this.maxLines) {
                        this.buffer.poll();
                    }
                }
                if (this.printStream == null) continue;
                this.printStream.println(this.printTimestamp ? entry.toString() : entry.message);
            }
        });
        this.loggerThread.setName("BufferedLogger_" + this);
        this.loggerThread.setDaemon(true);
        this.loggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedException {
        Object object = this.queueEmpty;
        synchronized (object) {
            if (this.queue.size() == 0) {
                return;
            }
            this.queueEmpty.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(long millis) {
        Object object = this.queueEmpty;
        synchronized (object) {
            if (this.queue.size() == 0) {
                return true;
            }
            try {
                this.queueEmpty.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.queue.size() == 0;
        }
    }

    public PrintStream printTo(PrintStream ps, boolean printTimestamp) {
        this.printTimestamp = printTimestamp;
        PrintStream old = this.printStream;
        this.printStream = ps;
        return old;
    }

    void setPrintTimestamp(boolean doPrint) {
        this.printTimestamp = doPrint;
    }

    public @NonNull Entry log(String message) {
        Entry entry = new Entry(message);
        this.queue.add(entry);
        return entry;
    }

    public @NonNull Entry d(String message) {
        return this.log(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull List<Entry> getLast(int maxEntries) {
        ArrayList<Entry> results = new ArrayList<Entry>(maxEntries);
        LinkedList<Entry> linkedList = this.buffer;
        synchronized (linkedList) {
            Iterator<Entry> it = this.buffer.descendingIterator();
            while (it.hasNext() & maxEntries > 0) {
                results.add(it.next());
                --maxEntries;
            }
        }
        Collections.reverse(results);
        return results;
    }

    public List<Entry> slice(long id, int maxEntries) {
        int toIndex;
        List<Entry> copy = this.getCopy();
        Entry start = new Entry(id);
        int fromIndex = Collections.binarySearch(copy, start);
        if (maxEntries > 0) {
            ++fromIndex;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((toIndex = fromIndex + maxEntries) < fromIndex) {
            int t = fromIndex;
            fromIndex = toIndex;
            toIndex = t;
        }
        int length = copy.size();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= length) {
            toIndex = length;
        }
        if (fromIndex >= length || toIndex < 1 || fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return copy.subList(fromIndex, toIndex);
    }

    public void clear() {
        this.buffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getCopy() {
        LinkedList<Entry> linkedList = this.buffer;
        synchronized (linkedList) {
            return new ArrayList<Entry>(this.buffer);
        }
    }

    public void interceptStdOut() {
        if (this.consoleIntercepted.getAndSet(true)) {
            return;
        }
        try {
            PipedOutputStream outPipe = new PipedOutputStream();
            this.oldOut = System.out;
            System.setOut(new PrintStream(outPipe, true));
            this.inPipe = new PipedInputStream(outPipe);
            BufferedReader r = new BufferedReader(new InputStreamReader(this.inPipe));
            this.interceptorThread = new Thread(() -> {
                try {
                    String s;
                    while ((s = r.readLine()) != null) {
                        this.log(s);
                        if (this.consoleIntercepted.get()) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    System.err.println("failed to read input" + e);
                    e.printStackTrace();
                }
            });
            this.interceptorThread.setDaemon(true);
            this.interceptorThread.start();
            this.interceptorThread.setName("BufferedLogger_console_interceptor");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to intercept stdout", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.stopInterceptingStdOut();
        if (this.loggerThread != null) {
            this.loggerThread.interrupt();
            this.loggerThread = null;
        }
    }

    public void stopInterceptingStdOut() {
        if (this.consoleIntercepted.getAndSet(false)) {
            System.setOut(this.oldOut);
            try {
                this.inPipe.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.interceptorThread.interrupt();
            this.interceptorThread = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static class Entry
    implements Comparable<Entry> {
        private static AtomicLong serial = new AtomicLong(System.currentTimeMillis());
        public final long id;
        public final Instant instant;
        public final String message;

        private Entry(String message) {
            this.id = serial.getAndIncrement();
            this.message = message.trim();
            this.instant = Instant.now();
        }

        protected Entry(Binder b) {
            this.id = b.getLongOrThrow("id");
            this.instant = Instant.ofEpochSecond(b.getLongOrThrow("instant"));
            this.message = b.getString("message");
        }

        private Entry(long id) {
            this.id = id;
            this.message = "";
            this.instant = Instant.now();
        }

        public String toString() {
            return "" + fmt.format(this.instant) + " " + this.message;
        }

        @Override
        public int compareTo(Entry e) {
            return Long.compare(this.id, e.id);
        }

        public Binder toBinder() {
            return Binder.fromKeysValues("id", this.id, "instant", this.instant.getEpochSecond(), "message", this.message);
        }

        static {
            DefaultBiMapper.registerAdapter(Entry.class, new BiAdapter(){

                public Binder serialize(Object object, BiSerializer serializer) {
                    return ((Entry)object).toBinder();
                }

                public Object deserialize(Binder binder, BiDeserializer deserializer) {
                    return new Entry(binder);
                }
            });
        }
    }
}

