/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

public class ByteRingBuffer {
    private final byte[] data;
    private final int capacity;
    private final Object access = new Object();
    private int rpos = 0;
    private int wpos = 0;

    public ByteRingBuffer(int capacity) {
        this.capacity = capacity;
        this.data = new byte[capacity];
    }

    private int advance(int index) {
        return (index + 1) % this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get() {
        Object object = this.access;
        synchronized (object) {
            while (this.rpos == this.wpos) {
                try {
                    this.access.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            int result = this.data[this.rpos] & 0xFF;
            this.rpos = this.advance(this.rpos);
            this.access.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Object object = this.access;
        synchronized (object) {
            if (this.rpos == this.wpos) {
                return -1;
            }
            return this.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int value) {
        Object object = this.access;
        synchronized (object) {
            while (this.advance(this.wpos) == this.rpos) {
                try {
                    this.access.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.data[this.wpos] = (byte)(value & 0xFF);
            this.wpos = this.advance(this.wpos);
            this.access.notifyAll();
        }
    }

    public byte[] get(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)this.get();
        }
        return result;
    }

    public void put(byte[] buffer) {
        for (byte b : buffer) {
            this.put(b);
        }
    }

    public <T extends Number> void put(Iterable<T> collection) {
        for (Number x : collection) {
            this.put(x.intValue());
        }
    }

    public String getString(int size) {
        return new String(this.get(size));
    }

    public void put(String s) {
        this.put(s.getBytes());
    }

    public boolean isEmpty() {
        return this.rpos == this.wpos;
    }

    public int read(byte[] b) {
        int res;
        int count = 0;
        while (count < b.length && (res = this.read()) >= 0) {
            b[count++] = (byte)res;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll() {
        Object object = this.access;
        synchronized (object) {
            int size = this.getAvailable();
            byte[] result = new byte[size];
            for (int i = 0; i < size; ++i) {
                result[i] = (byte)this.get();
            }
            return result;
        }
    }

    private int getAvailable() {
        int size = this.wpos - this.rpos;
        if (size < 0) {
            size += this.capacity;
        }
        return size;
    }
}

