/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.util.ArrayList;
import java.util.List;

public class DeferredResult {
    private final ArrayList<Handler> successHandlers = new ArrayList();
    private final ArrayList<Handler> errorHandlers = new ArrayList();
    private final ArrayList<Handler> doneHandlers = new ArrayList();
    private final Object access = new Object();
    private Object result;
    private boolean success;
    private boolean done;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredResult success(Handler handler) {
        ArrayList<Handler> arrayList = this.successHandlers;
        synchronized (arrayList) {
            this.successHandlers.add(handler);
        }
        if (this.done && this.success) {
            this.invokeSuccess();
        }
        return this;
    }

    private <T> void invokeSuccess() {
        this.invoke(this.successHandlers);
        this.invoke(this.doneHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(List<Handler> list) {
        List<Handler> list2 = list;
        synchronized (list2) {
            for (Handler h : list) {
                h.handle(this.result);
            }
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredResult failure(Handler handler) {
        ArrayList<Handler> arrayList = this.errorHandlers;
        synchronized (arrayList) {
            this.errorHandlers.add(handler);
        }
        if (this.done && !this.success) {
            this.invokeError();
        }
        return this;
    }

    private void invokeError() {
        this.invoke(this.errorHandlers);
        this.invoke(this.doneHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredResult done(Handler handler) {
        ArrayList<Handler> arrayList = this.doneHandlers;
        synchronized (arrayList) {
            this.doneHandlers.add(handler);
        }
        if (this.done) {
            this.invoke(this.doneHandlers);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSuccess(Object data) {
        Object object = this.access;
        synchronized (object) {
            if (!this.done) {
                this.success = true;
                this.done = true;
                this.result = data;
                this.invokeSuccess();
                this.access.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFailure(Object data) {
        Object object = this.access;
        synchronized (object) {
            if (!this.done) {
                this.success = false;
                this.done = true;
                this.result = data;
                this.invokeError();
                this.access.notifyAll();
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public <T> T getResult() {
        if (!this.done) {
            throw new IllegalStateException("result is not yet known");
        }
        return (T)this.result;
    }

    public <T> T waitSuccess() throws Error, InterruptedException {
        this.join();
        if (this.isSuccess()) {
            return (T)this.result;
        }
        if (this.result instanceof Exception) {
            throw new Error((Exception)this.result);
        }
        throw new Failure(this.result);
    }

    public <T> T await() throws InterruptedException {
        this.join();
        return (T)this.result;
    }

    public <T> T await(long millis) throws InterruptedException {
        return (T)(this.join(millis) ? this.result : null);
    }

    public final DeferredResult join() throws InterruptedException {
        this.join(0L);
        return this;
    }

    public boolean isSuccess() {
        return this.done && this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean join(long millis) throws InterruptedException {
        Object object = this.access;
        synchronized (object) {
            if (this.done) {
                return true;
            }
            this.access.wait(millis);
            return this.done;
        }
    }

    public static class Failure
    extends Error {
        private final Object failureData;

        Failure(Object failureData) {
            this.failureData = failureData;
        }

        public <T> T getFailureData() {
            return (T)this.failureData;
        }
    }

    public static class Error
    extends RuntimeException {
        Error(Exception inner) {
            super("Exception in defferred operation: " + inner.toString(), inner);
        }

        Error() {
            super("deffered operation failed");
        }
    }

    public static interface Handler {
        public void handle(Object var1);
    }
}

