/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sergeych.tools.DeferredResult;
import net.sergeych.utils.Base64;

public class Do {
    static Charset utf8 = Charset.forName("utf-8");
    static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static SecureRandom prng;
    private static final char[] hexArray;

    public static byte[] read(String fileName) throws IOException {
        try (FileInputStream f = new FileInputStream(fileName);){
            byte[] byArray = Do.read(f);
            return byArray;
        }
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        int l;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] block = new byte[8192];
        while ((l = inputStream.read(block)) >= 0) {
            bos.write(block, 0, l);
        }
        return bos.toByteArray();
    }

    public static String readToString(InputStream inputStream) throws IOException {
        return new String(Do.read(inputStream), utf8);
    }

    public static <A, B> A checkSame(A oldValue, B newValue, Runnable onChanged) {
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            onChanged.run();
            return (A)newValue;
        }
        return oldValue;
    }

    public static <T> T sample(Collection source) {
        int size = source.size();
        if (size <= 0) {
            return null;
        }
        int i = Do.randomInt(size);
        if (source instanceof List && source instanceof RandomAccess) {
            return (T)((List)source).get(i);
        }
        return (T)source.toArray()[i];
    }

    public static SecureRandom getRng() {
        if (prng == null) {
            try {
                prng = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("no SHA1PRNG found");
                throw new RuntimeException("no suitable RNG found", e);
            }
        }
        return prng;
    }

    public static int randomInt(int max) {
        return Do.getRng().nextInt(max);
    }

    public static byte[] randomBytes(int length) {
        byte[] data = new byte[length];
        Do.getRng().nextBytes(data);
        return data;
    }

    public static byte[] randomNegativeBytes(int length) {
        byte[] data = new byte[length];
        Do.getRng().nextBytes(data);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= 0) continue;
            data[i] = -data[i];
        }
        return data;
    }

    public static int randomIntInRange(int inclusiveMinimum, int inclusiveMaximum) {
        return Do.randomInt(inclusiveMaximum - inclusiveMinimum + 1) + inclusiveMinimum;
    }

    public static byte[] read(File f) throws IOException {
        return Files.readAllBytes(f.toPath());
    }

    public static void delay(long millis, Action action) {
        threadPool.execute(() -> {
            try {
                if (millis > 0L) {
                    Thread.sleep(millis);
                }
                action.perform();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void later(Action action) {
        Do.delay(0L, action);
    }

    public static HashMap<String, Object> map(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i].toString(), args[i + 1]);
        }
        return map;
    }

    public static <T> Collection<T> collection(Object x) {
        if (x instanceof Collection) {
            return (Collection)x;
        }
        return Do.list(x);
    }

    public static <T, U> ArrayList<T> list(U x) {
        if (x instanceof ArrayList) {
            return (ArrayList)x;
        }
        if (x instanceof Collection) {
            return new ArrayList((Collection)x);
        }
        if (x instanceof Collection) {
            return new ArrayList((Collection)x);
        }
        if (x.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int length = Array.getLength(x);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(x, i));
            }
            return list;
        }
        return null;
    }

    public static <T, U> ArrayList<T> listOf(U ... objects) {
        ArrayList<U> list = new ArrayList<U>();
        for (U x : objects) {
            list.add(x);
        }
        return list;
    }

    public static boolean deepEqualityTest(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number) {
            return b instanceof Number ? ((Number)a).doubleValue() == ((Number)b).doubleValue() : false;
        }
        if (a instanceof String) {
            return a.equals(b);
        }
        if (a.getClass().isArray() || a instanceof Collection) {
            Collection ca = Do.collection(a);
            Collection cb = Do.collection(b);
            if (ca.size() != cb.size()) {
                return false;
            }
            Iterator ita = ca.iterator();
            Iterator itb = cb.iterator();
            while (ita.hasNext()) {
                if (Do.deepEqualityTest(ita.next(), itb.next())) continue;
                return false;
            }
            return true;
        }
        if (a instanceof Map) {
            Map ma = (Map)a;
            Map mb = (Map)b;
            if (ma.size() != mb.size()) {
                return false;
            }
            for (Map.Entry e : ma.entrySet()) {
                if (Do.deepEqualityTest(e.getValue(), mb.get(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] decodeBase64(String base64) {
        String baseStr = base64.replace("\n", "").replace("\t", "").replace(" ", "").replace("\r", "");
        int n = baseStr.length() % 4;
        if (n > 0) {
            StringBuilder sb = new StringBuilder(baseStr);
            while (n++ < 4) {
                sb.append('=');
            }
            return Base64.decodeLines(sb.toString());
        }
        return Base64.decodeLines(baseStr);
    }

    public static DeferredResult inParallel(Task task) {
        DeferredResult deferredResult = new DeferredResult();
        threadPool.execute(() -> {
            try {
                deferredResult.sendSuccess(task.perform());
            }
            catch (Exception e) {
                deferredResult.sendFailure(e);
            }
        });
        return deferredResult;
    }

    public static DeferredResult inParallel(TaskWithoutResult task) {
        return Do.inParallel(() -> {
            task.perform();
            return null;
        });
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String snakeToCamelCase(String snakeString) {
        StringBuilder b = new StringBuilder();
        for (String s : snakeString.split("_")) {
            if (s.length() <= 0) continue;
            b.append(Character.toUpperCase(s.charAt(0)));
            b.append(s.substring(1, s.length()).toLowerCase());
        }
        return b.toString();
    }

    static {
        hexArray = "0123456789ABCDEF".toCharArray();
    }

    public static interface TaskWithoutResult {
        public void perform() throws Exception;
    }

    public static interface Task<T> {
        public T perform() throws Exception;
    }

    public static interface Action {
        public void perform() throws Exception;
    }
}

