/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sergeych.utils.Ut;

public class JsonTool {
    public static <T extends JsonValue> T toJson(Object object) {
        if (object == null) {
            return (T)Json.NULL;
        }
        if (object instanceof Number) {
            if (object instanceof Float || object instanceof Double) {
                return (T)Json.value(((Number)object).longValue());
            }
            return (T)Json.value(((Number)object).longValue());
        }
        if (object instanceof String) {
            return (T)Json.value((String)object);
        }
        if (object instanceof Boolean) {
            return (T)Json.value((Boolean)object);
        }
        if (object.getClass().isArray()) {
            JsonArray arr = new JsonArray();
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                arr.add((JsonValue)JsonTool.toJson(Array.get(object, i)));
            }
            return (T)arr;
        }
        if (object instanceof Iterable) {
            JsonArray arr = new JsonArray();
            for (Object x : (Iterable)object) {
                arr.add((JsonValue)JsonTool.toJson(x));
            }
            return (T)arr;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                jsonObject.set(entry.getKey().toString(), (JsonValue)JsonTool.toJson(entry.getValue()));
            }
            return (T)jsonObject;
        }
        if (object instanceof Date) {
            return JsonTool.toJson(Ut.mapFromArray("__type__", "datetime", "unixtime", (double)((Date)object).getTime() / 1000.0));
        }
        throw new IllegalArgumentException("Cant convert to json " + object + " of type " + object.getClass().getName());
    }

    public static String toJsonString(Object value) {
        return ((JsonValue)JsonTool.toJson(value)).toString();
    }

    public static <T> T fromJson(JsonValue jsonValue) {
        if (jsonValue.isNumber()) {
            double real = jsonValue.asDouble();
            return (T)(real != (double)((int)real) ? (Number)real : (Number)((long)real));
        }
        if (jsonValue.isString()) {
            return (T)jsonValue.asString();
        }
        if (jsonValue.isNull()) {
            return null;
        }
        if (jsonValue.isTrue()) {
            return (T)Boolean.TRUE;
        }
        if (jsonValue.isFalse()) {
            return (T)Boolean.FALSE;
        }
        if (jsonValue.isObject()) {
            JsonObject jo = (JsonObject)jsonValue;
            HashMap<String, T> result = new HashMap<String, T>();
            for (JsonObject.Member m : jo) {
                result.put(m.getName(), JsonTool.fromJson(m.getValue()));
            }
            return (T)result;
        }
        if (jsonValue.isArray()) {
            JsonArray array = (JsonArray)jsonValue;
            ArrayList<T> result = new ArrayList<T>(array.size());
            for (JsonValue value : array) {
                result.add(JsonTool.fromJson(value));
            }
            return (T)result;
        }
        throw new IllegalArgumentException("cant convert this type of value: " + jsonValue);
    }

    public static <T> T fromJson(String jsonString) {
        return JsonTool.fromJson(Json.parse(jsonString));
    }
}

