/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.util.ArrayList;
import java.util.List;
import net.sergeych.tools.Binder;
import net.sergeych.tools.JsonTool;

public class Reporter {
    private boolean quiet = false;
    private boolean verboseMode = false;
    private static final List<String> messages = new ArrayList<String>();
    private static final List<Binder> errors = new ArrayList<Binder>();

    public List<Binder> getErrors() {
        return errors;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public synchronized void notice(String text) {
        if (!this.quiet) {
            System.out.println(text);
        }
    }

    public synchronized void progress(String text) {
        if (!this.quiet) {
            System.out.print(text + "\r");
        }
    }

    public void verbose(String text) {
        if (this.verboseMode) {
            this.message(text);
        }
    }

    public synchronized void message(String text) {
        messages.add(text);
        if (!this.quiet) {
            System.out.println(text);
        }
    }

    public synchronized void error(String code, String object, String text) {
        errors.add(Binder.fromKeysValues("code", code, "object", object, "message", text));
        if (!this.quiet) {
            String msg = "** ERROR: " + code;
            if (object != null && !object.isEmpty()) {
                msg = msg + ": " + object;
            }
            if (text != null && !text.isEmpty()) {
                msg = msg + ": " + text;
            }
            System.out.println(msg);
        }
    }

    public void warning(String msg) {
        this.message(msg);
    }

    public Binder report() {
        return Binder.fromKeysValues("messages", messages, "errors", errors);
    }

    public synchronized String reportJson() {
        return JsonTool.toJsonString(this.report());
    }

    public synchronized String getMessage(int smartIndex) {
        if (smartIndex < 0) {
            smartIndex = messages.size() + smartIndex;
        }
        if (smartIndex < 0) {
            smartIndex = 0;
        }
        if (smartIndex >= messages.size()) {
            smartIndex = messages.size() - 1;
        }
        if (smartIndex < 0) {
            return null;
        }
        return messages.get(smartIndex);
    }

    public synchronized void clear() {
        messages.clear();
        errors.clear();
        this.quiet = false;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean verboseMode) {
        this.verboseMode = verboseMode;
    }

    public void newLine() {
        this.console("\n");
    }

    public void console(String text) {
        if (!this.quiet) {
            System.out.println(text);
        }
    }
}

