/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.util.ArrayList;

public class RingBuffer<T> {
    private final Object[] data;
    private final int capacity;
    private final Object access = new Object();
    private int rpos = 0;
    private int wpos = 0;

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.data = new Object[capacity];
    }

    private int advance(int index) {
        return (index + 1) % this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.access;
        synchronized (object) {
            while (this.rpos == this.wpos) {
                try {
                    this.access.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object result = this.data[this.rpos];
            this.rpos = this.advance(this.rpos);
            this.access.notifyAll();
            return (T)result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() {
        Object object = this.access;
        synchronized (object) {
            if (this.rpos == this.wpos) {
                return null;
            }
            return this.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object value) {
        Object object = this.access;
        synchronized (object) {
            while (this.advance(this.wpos) == this.rpos) {
                try {
                    this.access.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.data[this.wpos] = value;
            this.wpos = this.advance(this.wpos);
            this.access.notifyAll();
        }
    }

    public void put(Iterable<T> collection) {
        for (T x : collection) {
            this.put(x);
        }
    }

    public boolean isEmpty() {
        return this.rpos == this.wpos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> readAll() {
        Object object = this.access;
        synchronized (object) {
            int size = this.getAvailable();
            ArrayList<T> result = new ArrayList<T>();
            for (int i = 0; i < size; ++i) {
                result.add(this.get());
            }
            return result;
        }
    }

    private int getAvailable() {
        int size = this.wpos - this.rpos;
        if (size < 0) {
            size += this.capacity;
        }
        return size;
    }
}

