/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RunnableWithDynamicPeriod
implements Runnable {
    private Runnable lambda;
    private List<Integer> periods;
    private int waitsCount = 0;
    private ScheduledFuture<?> future;
    private ScheduledExecutorService es;

    public RunnableWithDynamicPeriod(Runnable lambda, List<Integer> periods, ScheduledExecutorService es) {
        this.lambda = lambda;
        this.periods = periods;
        this.es = es;
    }

    @Override
    public void run() {
        if (this.waitsCount > 0) {
            this.lambda.run();
        }
        int l = this.periods.get(this.periods.size() - 1);
        if (this.waitsCount < this.periods.size() - 1) {
            l = this.periods.get(this.waitsCount);
        }
        this.future = this.es.schedule(this, (long)l, TimeUnit.MILLISECONDS);
        ++this.waitsCount;
    }

    public void cancel(boolean b) {
        if (this.future != null) {
            this.future.cancel(b);
        }
    }
}

