/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sergeych.tools.ByteRingBuffer;
import net.sergeych.utils.Bytes;

public class StreamConnector {
    private final InputStream in;
    private final OutputStream out;
    private final ByteRingBuffer buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public StreamConnector() {
        this(512);
    }

    public StreamConnector(int bufferSize) {
        this.buffer = new ByteRingBuffer(bufferSize);
        this.in = new InputStream(){

            @Override
            public int read() throws IOException {
                if (StreamConnector.this.closed.get()) {
                    this.close();
                    return -1;
                }
                return StreamConnector.this.buffer.get();
            }

            @Override
            public void close() throws IOException {
                super.close();
                StreamConnector.this.close();
            }
        };
        this.out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                StreamConnector.this.buffer.put(b);
            }
        };
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void dump() {
        new Bytes(new byte[][]{this.buffer.readAll()}).dump();
    }
}

