/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.utils;

public class Base64 {
    protected static final boolean DEBUGGING = false;
    protected static final int IGNORE = -1;
    protected static final int PAD = -2;
    private static final int FIRST_COPYRIGHT_YEAR = 1999;
    private static final String EMBEDDED_COPYRIGHT = "Copyright: (c) 1999-2014 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String RELEASE_DATE = "2007-05-20";
    private static final String TITLE_STRING = "Base64";
    private static final String VERSION_STRING = "1.9";
    protected static int[] cv;
    protected static char[] vc;
    protected String lineSeparator = System.getProperty("line.separator");
    protected char[] valueToChar;
    protected char spec1 = (char)43;
    protected char spec2 = (char)47;
    protected char spec3 = (char)61;
    protected int[] charToValue;
    protected int lineLength = 72;

    public static byte[] decodeLines(String s) {
        char[] buf = new char[s.length()];
        int p = 0;
        for (int ip = 0; ip < s.length(); ++ip) {
            char c = s.charAt(ip);
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t') continue;
            buf[p++] = c;
        }
        return new Base64().decode(new String(buf));
    }

    public static String encodeString(byte[] data) {
        Base64 b = new Base64();
        b.setLineLength(0);
        return b.encode(data);
    }

    public static String encodeCompactString(byte[] data) {
        int last;
        String s = Base64.encodeString(data);
        for (last = s.length() - 1; last > 0 && s.charAt(last) == '='; --last) {
        }
        return s.substring(0, last + 1);
    }

    public static String encodeLines(byte[] data) {
        Base64 b = new Base64();
        b.setLineLength(72);
        return b.encode(data);
    }

    public Base64() {
        this.spec1 = (char)43;
        this.spec2 = (char)47;
        this.spec3 = (char)61;
        this.initTables();
    }

    public static void show(byte[] b) {
        for (byte aB : b) {
            System.out.print(Integer.toHexString(aB & 0xFF) + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) {
    }

    public byte[] decode(String s) {
        byte[] b = new byte[s.length() / 4 * 3];
        int cycle = 0;
        int combined = 0;
        int j = 0;
        int len = s.length();
        int dummies = 0;
        block10: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int value = c <= '\u00ff' ? this.charToValue[c] : -1;
            switch (value) {
                case -1: {
                    continue block10;
                }
                case -2: {
                    value = 0;
                    ++dummies;
                }
                default: {
                    switch (cycle) {
                        case 0: {
                            combined = value;
                            cycle = 1;
                            continue block10;
                        }
                        case 1: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 2;
                            continue block10;
                        }
                        case 2: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 3;
                            continue block10;
                        }
                        case 3: {
                            combined <<= 6;
                            b[j + 2] = (byte)(combined |= value);
                            b[j + 1] = (byte)(combined >>>= 8);
                            b[j] = (byte)(combined >>>= 8);
                            j += 3;
                            cycle = 0;
                        }
                    }
                }
            }
        }
        if (cycle != 0) {
            throw new ArrayIndexOutOfBoundsException("Input to decode not an even multiple of 4 characters; pad with " + this.spec3);
        }
        if (b.length != (j -= dummies)) {
            byte[] b2 = new byte[j];
            System.arraycopy(b, 0, b2, 0, j);
            b = b2;
        }
        return b;
    }

    public String encode(byte[] b) {
        int lines;
        int outputLength = (b.length + 2) / 3 * 4;
        if (this.lineLength != 0 && (lines = (outputLength + this.lineLength - 1) / this.lineLength - 1) > 0) {
            outputLength += lines * this.lineSeparator.length();
        }
        StringBuilder sb = new StringBuilder(outputLength);
        int linePos = 0;
        int len = b.length / 3 * 3;
        int leftover = b.length - len;
        for (int i = 0; i < len; i += 3) {
            if ((linePos += 4) > this.lineLength) {
                if (this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                linePos = 4;
            }
            int combined = b[i] & 0xFF;
            combined <<= 8;
            combined |= b[i + 1] & 0xFF;
            combined <<= 8;
            int c3 = (combined |= b[i + 2] & 0xFF) & 0x3F;
            int c2 = (combined >>>= 6) & 0x3F;
            int c1 = (combined >>>= 6) & 0x3F;
            int c0 = (combined >>>= 6) & 0x3F;
            sb.append(this.valueToChar[c0]);
            sb.append(this.valueToChar[c1]);
            sb.append(this.valueToChar[c2]);
            sb.append(this.valueToChar[c3]);
        }
        switch (leftover) {
            default: {
                break;
            }
            case 1: {
                if ((linePos += 4) > this.lineLength && this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                sb.append(this.encode(new byte[]{b[len], 0, 0}).substring(0, 2));
                sb.append(this.spec3);
                sb.append(this.spec3);
                break;
            }
            case 2: {
                if ((linePos += 4) > this.lineLength && this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                sb.append(this.encode(new byte[]{b[len], b[len + 1], 0}).substring(0, 3));
                sb.append(this.spec3);
            }
        }
        if (outputLength != sb.length()) {
            System.out.println("oops: minor program flaw: output length mis-estimated");
            System.out.println("estimate:" + outputLength);
            System.out.println("actual:" + sb.length());
        }
        return sb.toString();
    }

    public final void setLineLength(int length) {
        this.lineLength = length / 4 * 4;
    }

    public final void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private void initTables() {
        if (vc == null) {
            int i;
            vc = new char[64];
            cv = new int[256];
            for (i = 0; i <= 25; ++i) {
                Base64.vc[i] = (char)(65 + i);
            }
            for (i = 0; i <= 25; ++i) {
                Base64.vc[i + 26] = (char)(97 + i);
            }
            for (i = 0; i <= 9; ++i) {
                Base64.vc[i + 52] = (char)(48 + i);
            }
            Base64.vc[62] = this.spec1;
            Base64.vc[63] = this.spec2;
            for (i = 0; i < 256; ++i) {
                Base64.cv[i] = -1;
            }
            for (i = 0; i < 64; ++i) {
                Base64.cv[Base64.vc[i]] = i;
            }
            Base64.cv[this.spec3] = -2;
        }
        this.valueToChar = vc;
        this.charToValue = cv;
    }

    public static byte[] decodeCompactString(String s) {
        StringBuilder sb = new StringBuilder(s.trim());
        int n = sb.length() % 4;
        if (n > 0) {
            n = 4 - n;
            while (n-- > 0) {
                sb.append('=');
            }
        }
        return Base64.decodeLines(sb.toString());
    }
}

