/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import net.sergeych.utils.Base64;
import net.sergeych.utils.LogPrinter;
import net.sergeych.utils.Ut;

public class Bytes
implements Serializable {
    private static final Charset utf8 = Charset.forName("utf8");
    private static SecureRandom rng = null;
    private static LogPrinter log = new LogPrinter("Bytes");
    final byte[] data;
    private boolean noHashcode = true;
    private int cachedHashCode;

    public Bytes(String string) {
        this(new byte[][]{string.getBytes(utf8)});
    }

    public Bytes(byte[] ... arrays) {
        if (arrays.length == 1) {
            this.data = arrays[0];
        } else {
            int length = 0;
            for (byte[] x : arrays) {
                length += x.length;
            }
            this.data = new byte[length];
            int pos = 0;
            for (byte[] x : arrays) {
                System.arraycopy(x, 0, this.data, pos, x.length);
                pos += x.length;
            }
        }
    }

    public Bytes(InputStream in, int length) throws IOException {
        if (length > 0) {
            this.data = new byte[length];
            Ut.readFully(in, this.data);
        } else {
            this.data = Ut.readFully(in);
        }
    }

    public Bytes(ByteArrayOutputStream bos) {
        this(new byte[][]{bos.toByteArray()});
    }

    public Bytes(int size) {
        this(new byte[][]{new byte[size]});
    }

    public static Bytes fromHex(String hex) {
        ArrayList<Byte> data = new ArrayList<Byte>(hex.length() / 2);
        int l = hex.length();
        for (int i = 0; i < l; ++i) {
            char c = hex.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (i + 1 >= l) {
                throw new IllegalArgumentException("Hex format failure: even number of digits");
            }
            int val = (Character.digit(c, 16) << 4) + Character.digit(hex.charAt(i + 1), 16);
            data.add((byte)val);
            ++i;
        }
        byte[] result = new byte[data.size()];
        int i = 0;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            byte b = (Byte)iterator.next();
            result[i++] = b;
        }
        return new Bytes(new byte[][]{result});
    }

    public static byte[] hexToByteArray(String hex) {
        return Bytes.fromHex(hex).toArray();
    }

    public static Bytes fromBase64(String baseStr) {
        int n = (baseStr = baseStr.replace("\n", "").replace("\t", "").replace(" ", "").replace("\r", "")).length() % 4;
        if (n > 0) {
            StringBuilder sb = new StringBuilder(baseStr);
            while (n-- > 0) {
                sb.append('=');
            }
            return new Bytes(new byte[][]{Base64.decodeLines(sb.toString())});
        }
        return new Bytes(new byte[][]{Base64.decodeLines(baseStr)});
    }

    public static Bytes fromString(String str) {
        return new Bytes(str);
    }

    public static Bytes fromBigInt(BigInteger value) {
        return new Bytes(new byte[][]{value.toByteArray()});
    }

    public static Bytes fromDouble(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).putDouble(value);
        return new Bytes(new byte[][]{bytes});
    }

    public int size() {
        return this.data.length;
    }

    public boolean empty() {
        return this.data == null || this.data.length == 0;
    }

    public Bytes flipSelf() {
        int i = 0;
        int j = this.data.length - 1;
        while (i < j) {
            byte x = this.data[i];
            this.data[i++] = this.data[j];
            this.data[j--] = x;
        }
        if (this.data.length > 0) {
            this.noHashcode = true;
        }
        return this;
    }

    public final byte[] toArray() {
        return this.data;
    }

    public void dump() {
        Bytes.dump(this.data);
    }

    public static void dump(byte[] data) {
        String[] lines = Bytes.toDump(data);
        if (lines.length > 0) {
            for (String s : lines) {
                log.i(s, new Object[0]);
            }
        } else {
            log.i("Dump: no data", new Object[0]);
        }
    }

    public static String[] toDump(byte[] data) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = null;
        if (data.length != 0) {
            for (int i = 0; i < data.length; ++i) {
                if (i % 16 == 0) {
                    if (line != null) {
                        line.append(Bytes.dumpChars(data, i - 16));
                        lines.add(line.toString());
                    }
                    line = new StringBuilder(String.format("%04X ", i));
                }
                line.append(String.format("%02X ", data[i]));
            }
            if (line != null) {
                int index;
                int l = data.length;
                int fill = 16 - l % 16;
                if (fill < 16) {
                    while (fill-- > 0) {
                        line.append("   ");
                    }
                }
                line.append(Bytes.dumpChars(data, (index = l - l % 16) < l ? index : l - 16));
                lines.add(line.toString());
            }
        }
        return lines.toArray(new String[0]);
    }

    private static String dumpChars(byte[] data, int from) {
        StringBuilder b = new StringBuilder(22);
        b.append("|");
        int max = Math.min(data.length, from + 16);
        while (from < max) {
            byte ch;
            if ((ch = data[from++]) >= 32 && ch < 127) {
                b.append((char)ch);
                continue;
            }
            b.append('.');
        }
        int f16 = from % 16;
        if (f16 > 0) {
            int cnt = 16 - f16;
            while (cnt-- > 0) {
                b.append(' ');
            }
        }
        return b.append("|").toString();
    }

    public String toDump() {
        StringBuilder b = new StringBuilder();
        for (String line : Bytes.toDump(this.data)) {
            b.append(line);
            b.append("\n");
        }
        return b.toString();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.data);
    }

    public String inspect() {
        String res = new String(this.data, utf8);
        for (int i = 0; i < res.length(); ++i) {
            int codePoint = res.codePointAt(i);
            if (Character.isDefined(codePoint)) continue;
            return "b64:" + this.toBase64();
        }
        return "t:" + res;
    }

    public String toBase64() {
        return Base64.encodeString(this.data);
    }

    public String toHex() {
        StringBuilder str = new StringBuilder();
        for (byte b : this.data) {
            str.append(String.format("%02X ", b));
        }
        return str.toString().trim();
    }

    public String toHex(boolean useSpaces) {
        StringBuilder str = new StringBuilder();
        if (useSpaces) {
            for (byte b : this.data) {
                str.append(String.format("%02X ", b));
            }
        } else {
            for (byte b : this.data) {
                str.append(String.format("%02X", b));
            }
        }
        return str.toString().trim();
    }

    public String toBase64Lines() {
        return Base64.encodeLines(this.data);
    }

    public int hashCode() {
        if (this.noHashcode) {
            CRC32 crc = new CRC32();
            crc.update(this.data);
            this.cachedHashCode = (int)crc.getValue();
            this.noHashcode = false;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof byte[]) {
            return Arrays.equals((byte[])obj, this.data);
        }
        if (obj instanceof Bytes) {
            byte[] other = ((Bytes)obj).data;
            return Arrays.equals(other, this.data);
        }
        return super.equals(obj);
    }

    public String toString() {
        return new String(this.data, utf8);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public Object toDouble() {
        return ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public Bytes sha1() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 is not implemented");
        }
        md.update(this.data);
        return new Bytes(new byte[][]{md.digest()});
    }

    public Bytes sha256(Object ... chunks) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 is not implemented");
        }
        md.update(this.data);
        for (Object x : chunks) {
            if (x instanceof String) {
                x = ((String)x).getBytes();
            }
            if (x instanceof byte[]) {
                md.update((byte[])x);
                continue;
            }
            if (!(x instanceof Bytes)) continue;
            md.update(((Bytes)x).data);
        }
        return new Bytes(new byte[][]{md.digest()});
    }

    public ByteArrayInputStream toInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public Bytes part(int start) {
        return this.part(start, 0);
    }

    public Bytes part(int start, int length) {
        int end;
        if (start < 0) {
            start = this.data.length + start;
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Bytes#part: start index out of bounds");
        }
        if (length < 1) {
            length = this.data.length;
        }
        if ((end = start + length) > this.data.length) {
            end = this.data.length;
        }
        byte[] dst = Arrays.copyOfRange(this.data, start, end);
        return new Bytes(new byte[][]{dst});
    }

    public Bytes fillRandom(int length) {
        return this.concatenate(Bytes.random(length));
    }

    public Bytes concatenate(Bytes other) {
        int newLength = this.data.length + other.data.length;
        byte[] res = Arrays.copyOf(this.data, newLength);
        int j = 0;
        for (int i = this.data.length; i < newLength; ++i) {
            res[i] = other.data[j++];
        }
        return new Bytes(new byte[][]{res});
    }

    public <T> Bytes concatenate(List<T> other) {
        int newLength = this.data.length + other.size();
        byte[] res = Arrays.copyOf(this.data, newLength);
        int j = 0;
        for (int i = this.data.length; i < newLength; ++i) {
            res[i] = (byte)((Integer)other.get(j++) & 0xFF);
        }
        return new Bytes(new byte[][]{res});
    }

    public Bytes concatenate(byte[] otherBytes) {
        return this.concatenate(new Bytes(new byte[][]{otherBytes}));
    }

    public static Bytes random(int length) {
        if (rng == null) {
            try {
                rng = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.e("Cant create RNG for ids!", new Object[0]);
                throw new RuntimeException("Can't create suitable PRNG");
            }
        }
        byte[] data = new byte[length];
        rng.nextBytes(data);
        return new Bytes(new byte[][]{data});
    }

    public Bytes padToSize(int size, int fillByte) {
        if (this.data.length >= size) {
            return new Bytes(new byte[][]{this.data});
        }
        byte[] res = Arrays.copyOf(this.data, size);
        if (fillByte != 0) {
            for (int i = this.data.length; i < size; ++i) {
                res[i] = (byte)fillByte;
            }
        }
        return new Bytes(new byte[][]{res});
    }

    public Bytes concatenate(String s) {
        return this.concatenate(new Bytes(s));
    }

    public Bytes reverse() {
        int length = this.data.length;
        int l1 = length - 1;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.data[l1 - i];
        }
        return new Bytes(new byte[][]{result});
    }

    public Bytes correctIntFromGMP() {
        return this;
    }

    public static String toHex(byte[] data) {
        StringBuilder str = new StringBuilder();
        for (byte b : data) {
            str.append(String.format("%02X ", b));
        }
        return str.toString().trim();
    }

    public byte[] getData() {
        return this.data;
    }
}

