/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LogPrinter {
    private static boolean showDebugMessages = false;
    private String tag;
    private static ExecutorService es = Executors.newSingleThreadExecutor();

    public static void showDebug(boolean show) {
        showDebugMessages = show;
    }

    public LogPrinter(String tag) {
        this.tag = tag;
    }

    public void i(String format, Object ... objects) {
        this.log('i', this.tag, format, objects);
    }

    public void log(char type, String tag, String message, Object ... params) {
        if (type == 'd' && !showDebugMessages) {
            return;
        }
        if (params.length == 0) {
            this.outputLog(tag, message);
        } else {
            this.outputLog(tag, String.format(message, params));
        }
    }

    public void log(char type, String tag, Callable<String> source) {
        es.submit(() -> {
            if (type == 'd' && !showDebugMessages) {
                return;
            }
            try {
                this.log(type, tag, (String)source.call());
            }
            catch (Exception e) {
                this.wtf("Exception in log source callable: ", e);
            }
        });
    }

    public void e(Callable<String> msg) {
        this.log('e', this.tag, msg);
    }

    public void log(char type, String tag, String message) {
        es.submit(() -> {
            if (type == 'd' && !showDebugMessages) {
                return;
            }
            this.outputLog(tag, message);
        });
    }

    public void outputLog(String tag, String message) {
        System.out.printf("%s %s\n", tag, message);
    }

    public void d(String text) {
        if (!showDebugMessages) {
            return;
        }
        this.log('d', this.tag, text);
    }

    public void d(Callable<String> source) {
        if (showDebugMessages) {
            this.log('d', this.tag, source);
        }
    }

    public void d(String format, Object ... objects) {
        if (showDebugMessages) {
            this.log('d', this.tag, format, objects);
        }
    }

    public void w(String format, Object ... objects) {
        this.log('w', this.tag, format, objects);
    }

    public void e(String format, Object ... objects) {
        this.log('e', this.tag, format, objects);
    }

    public void wtf(String message, Throwable t) {
        this.log('f', this.tag, message + ": " + t);
        t.printStackTrace();
    }
}

