/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sergeych.utils.LogPrinter;

public class Ut {
    private static final String idChars = "0123456789_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static Charset utf8 = Charset.forName("utf-8");
    private static SecureRandom rng;
    private static LogPrinter log;
    static Boolean testEnv;

    public static String randomString(int length) {
        if (rng == null) {
            try {
                rng = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.e("Cant create RNG for ids!", new Object[0]);
                throw new RuntimeException("Can't create suitable PRNG");
            }
        }
        StringBuilder sb = new StringBuilder();
        while (length-- > 0) {
            sb.append(idChars.charAt(Math.abs(rng.nextInt()) % idChars.length()));
        }
        return sb.toString();
    }

    public static String randomString(int length, String alphabet) {
        if (rng == null) {
            try {
                rng = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.e("Cant create RNG for ids!", new Object[0]);
                throw new RuntimeException("Can't create suitable PRNG");
            }
        }
        StringBuilder sb = new StringBuilder();
        String chars = alphabet;
        while (length-- > 0) {
            sb.append(idChars.charAt(Math.abs(rng.nextInt()) % chars.length()));
        }
        return sb.toString();
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException, EOFException {
        int cnt;
        int read = 0;
        do {
            if ((cnt = inputStream.read(buffer, read, buffer.length - read)) >= 0) continue;
            throw new EOFException();
        } while ((read += cnt) < buffer.length);
    }

    public static String readToString(InputStream inputStream) throws IOException {
        return new String(Ut.readFully(inputStream), utf8);
    }

    public static Object[] array(Object ... objects) {
        return Arrays.copyOf(objects, objects.length);
    }

    public static List<String> stringList(Object ... objects) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object x : objects) {
            list.add(x.toString());
        }
        return list;
    }

    public static <T> ArrayList<T> arrayToList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object x : array) {
            list.add(x);
        }
        return list;
    }

    public static ArrayList<String> arrayToStringList(Object[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object x : array) {
            list.add(x.toString());
        }
        return list;
    }

    public static HashMap<String, Object> mapFromArray(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i].toString(), args[i + 1]);
        }
        return map;
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        assert (map != null);
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey().toString() + ": " + entry.getValue());
        }
        return sb.toString() + "}";
    }

    public static void later(final Callable callable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (Exception x) {
                    log.e("later: Exception:", x);
                }
            }
        }).start();
    }

    public static Object trimWithEllipsis(String text, int maxLen) {
        int l;
        if (maxLen < 4) {
            maxLen = 4;
        }
        if (text == null) {
            text = "null";
        }
        if (maxLen >= (l = text.length())) {
            return text;
        }
        return text.substring(0, maxLen - 3) + "...";
    }

    public static boolean same(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static boolean deleteRecursive(File path) throws IOException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                if (Ut.isSymlink(f)) continue;
                ret = ret && Ut.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static <T> String join(Collection<T> collection, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T item : collection) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(item.toString());
        }
        return sb.toString();
    }

    public static boolean different(Object x, Object y) {
        return !Ut.same(x, y);
    }

    public static <T> ArrayList<T> list(T ... objects) {
        ArrayList<T> result = new ArrayList<T>(objects.length);
        for (T x : objects) {
            result.add(x);
        }
        return result;
    }

    public static boolean isJUnitTest() {
        if (testEnv == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            List<StackTraceElement> list = Arrays.asList(stackTrace);
            for (StackTraceElement element : list) {
                if (!element.getClassName().startsWith("org.junit.")) continue;
                testEnv = true;
                return testEnv;
            }
            testEnv = false;
        }
        return testEnv;
    }

    static {
        log = new LogPrinter("sergeych.ut");
        testEnv = null;
    }
}

