/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.engines;

import java.math.BigInteger;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.engines.RSACoreEngine;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.params.RSABlindingParameters;
import org.spongycastle.crypto.params.RSAKeyParameters;

public class RSABlindingEngine
implements AsymmetricBlockCipher {
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private BigInteger blindingFactor;
    private boolean forEncryption;

    public void init(boolean forEncryption, CipherParameters param2) {
        RSABlindingParameters p;
        if (param2 instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param2;
            p = (RSABlindingParameters)rParam.getParameters();
        } else {
            p = (RSABlindingParameters)param2;
        }
        this.core.init(forEncryption, p.getPublicKey());
        this.forEncryption = forEncryption;
        this.key = p.getPublicKey();
        this.blindingFactor = p.getBlindingFactor();
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger msg = this.core.convertInput(in, inOff, inLen);
        msg = this.forEncryption ? this.blindMessage(msg) : this.unblindMessage(msg);
        return this.core.convertOutput(msg);
    }

    private BigInteger blindMessage(BigInteger msg) {
        BigInteger blindMsg = this.blindingFactor;
        blindMsg = msg.multiply(blindMsg.modPow(this.key.getExponent(), this.key.getModulus()));
        blindMsg = blindMsg.mod(this.key.getModulus());
        return blindMsg;
    }

    private BigInteger unblindMessage(BigInteger blindedMsg) {
        BigInteger m = this.key.getModulus();
        BigInteger msg = blindedMsg;
        BigInteger blindFactorInverse = this.blindingFactor.modInverse(m);
        msg = msg.multiply(blindFactorInverse);
        msg = msg.mod(m);
        return msg;
    }
}

