/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSABlindingFactorGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters param2) {
        if (param2 instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param2;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param2;
            this.random = new SecureRandom();
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            throw new IllegalArgumentException("generator requires RSA public key");
        }
    }

    public BigInteger generateBlindingFactor() {
        BigInteger gcd;
        BigInteger factor;
        if (this.key == null) {
            throw new IllegalStateException("generator not initialised");
        }
        BigInteger m = this.key.getModulus();
        int length = m.bitLength() - 1;
        do {
            factor = new BigInteger(length, this.random);
            gcd = factor.gcd(m);
        } while (factor.equals(ZERO) || factor.equals(ONE) || !gcd.equals(ONE));
        return factor;
    }
}

