/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.spongycastle.pqc.math.linearalgebra.GF2mField;
import org.spongycastle.pqc.math.linearalgebra.GF2mVector;
import org.spongycastle.pqc.math.linearalgebra.IntUtils;
import org.spongycastle.pqc.math.linearalgebra.RandUtils;

public class PolynomialGF2mSmallM {
    private GF2mField field;
    private int degree;
    private int[] coefficients;
    public static final char RANDOM_IRREDUCIBLE_POLYNOMIAL = 'I';

    public PolynomialGF2mSmallM(GF2mField field2) {
        this.field = field2;
        this.degree = -1;
        this.coefficients = new int[1];
    }

    public PolynomialGF2mSmallM(GF2mField field2, int deg, char typeOfPolynomial, SecureRandom sr) {
        this.field = field2;
        switch (typeOfPolynomial) {
            case 'I': {
                this.coefficients = this.createRandomIrreduciblePolynomial(deg, sr);
                break;
            }
            default: {
                throw new IllegalArgumentException(" Error: type " + typeOfPolynomial + " is not defined for GF2smallmPolynomial");
            }
        }
        this.computeDegree();
    }

    private int[] createRandomIrreduciblePolynomial(int deg, SecureRandom sr) {
        int[] resCoeff = new int[deg + 1];
        resCoeff[deg] = 1;
        resCoeff[0] = this.field.getRandomNonZeroElement(sr);
        for (int i = 1; i < deg; ++i) {
            resCoeff[i] = this.field.getRandomElement(sr);
        }
        while (!this.isIrreducible(resCoeff)) {
            int n = RandUtils.nextInt(sr, deg);
            if (n == 0) {
                resCoeff[0] = this.field.getRandomNonZeroElement(sr);
                continue;
            }
            resCoeff[n] = this.field.getRandomElement(sr);
        }
        return resCoeff;
    }

    public PolynomialGF2mSmallM(GF2mField field2, int degree) {
        this.field = field2;
        this.degree = degree;
        this.coefficients = new int[degree + 1];
        this.coefficients[degree] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField field2, int[] coeffs) {
        this.field = field2;
        this.coefficients = PolynomialGF2mSmallM.normalForm(coeffs);
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField field2, byte[] enc) {
        int d;
        this.field = field2;
        int count = 1;
        for (d = 8; field2.getDegree() > d; d += 8) {
            ++count;
        }
        if (enc.length % count != 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.coefficients = new int[enc.length / count];
        count = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < d; j += 8) {
                int n = i;
                this.coefficients[n] = this.coefficients[n] ^ (enc[count++] & 0xFF) << j;
            }
            if (this.field.isElementOfThisField(this.coefficients[i])) continue;
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        if (this.coefficients.length != 1 && this.coefficients[this.coefficients.length - 1] == 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM other) {
        this.field = other.field;
        this.degree = other.degree;
        this.coefficients = IntUtils.clone(other.coefficients);
    }

    public PolynomialGF2mSmallM(GF2mVector vect) {
        this(vect.getField(), vect.getIntArrayForm());
    }

    public int getDegree() {
        int d = this.coefficients.length - 1;
        if (this.coefficients[d] == 0) {
            return -1;
        }
        return d;
    }

    public int getHeadCoefficient() {
        if (this.degree == -1) {
            return 0;
        }
        return this.coefficients[this.degree];
    }

    private static int headCoefficient(int[] a) {
        int degree = PolynomialGF2mSmallM.computeDegree(a);
        if (degree == -1) {
            return 0;
        }
        return a[degree];
    }

    public int getCoefficient(int index) {
        if (index < 0 || index > this.degree) {
            return 0;
        }
        return this.coefficients[index];
    }

    public byte[] getEncoded() {
        int d;
        int count = 1;
        for (d = 8; this.field.getDegree() > d; d += 8) {
            ++count;
        }
        byte[] res = new byte[this.coefficients.length * count];
        count = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < d; j += 8) {
                res[count++] = (byte)(this.coefficients[i] >>> j);
            }
        }
        return res;
    }

    public int evaluateAt(int e) {
        int result = this.coefficients[this.degree];
        for (int i = this.degree - 1; i >= 0; --i) {
            result = this.field.mult(result, e) ^ this.coefficients[i];
        }
        return result;
    }

    public PolynomialGF2mSmallM add(PolynomialGF2mSmallM addend) {
        int[] resultCoeff = this.add(this.coefficients, addend.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public void addToThis(PolynomialGF2mSmallM addend) {
        this.coefficients = this.add(this.coefficients, addend.coefficients);
        this.computeDegree();
    }

    private int[] add(int[] a, int[] b) {
        int[] addend;
        int[] result;
        if (a.length < b.length) {
            result = new int[b.length];
            System.arraycopy(b, 0, result, 0, b.length);
            addend = a;
        } else {
            result = new int[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            addend = b;
        }
        for (int i = addend.length - 1; i >= 0; --i) {
            result[i] = this.field.add(result[i], addend[i]);
        }
        return result;
    }

    public PolynomialGF2mSmallM addMonomial(int degree) {
        int[] monomial = new int[degree + 1];
        monomial[degree] = 1;
        int[] resultCoeff = this.add(this.coefficients, monomial);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM multWithElement(int element) {
        if (!this.field.isElementOfThisField(element)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        int[] resultCoeff = this.multWithElement(this.coefficients, element);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public void multThisWithElement(int element) {
        if (!this.field.isElementOfThisField(element)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        this.coefficients = this.multWithElement(this.coefficients, element);
        this.computeDegree();
    }

    private int[] multWithElement(int[] a, int element) {
        int degree = PolynomialGF2mSmallM.computeDegree(a);
        if (degree == -1 || element == 0) {
            return new int[1];
        }
        if (element == 1) {
            return IntUtils.clone(a);
        }
        int[] result = new int[degree + 1];
        for (int i = degree; i >= 0; --i) {
            result[i] = this.field.mult(a[i], element);
        }
        return result;
    }

    public PolynomialGF2mSmallM multWithMonomial(int k) {
        int[] resultCoeff = PolynomialGF2mSmallM.multWithMonomial(this.coefficients, k);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private static int[] multWithMonomial(int[] a, int k) {
        int d = PolynomialGF2mSmallM.computeDegree(a);
        if (d == -1) {
            return new int[1];
        }
        int[] result = new int[d + k + 1];
        System.arraycopy(a, 0, result, k, d + 1);
        return result;
    }

    public PolynomialGF2mSmallM[] div(PolynomialGF2mSmallM f) {
        int[][] resultCoeffs = this.div(this.coefficients, f.coefficients);
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.field, resultCoeffs[0]), new PolynomialGF2mSmallM(this.field, resultCoeffs[1])};
    }

    private int[][] div(int[] a, int[] f) {
        int df = PolynomialGF2mSmallM.computeDegree(f);
        int da = PolynomialGF2mSmallM.computeDegree(a) + 1;
        if (df == -1) {
            throw new ArithmeticException("Division by zero.");
        }
        int[][] result = new int[][]{new int[1], new int[da]};
        int hc = PolynomialGF2mSmallM.headCoefficient(f);
        hc = this.field.inverse(hc);
        result[0][0] = 0;
        System.arraycopy(a, 0, result[1], 0, result[1].length);
        while (df <= PolynomialGF2mSmallM.computeDegree(result[1])) {
            int[] coeff = new int[]{this.field.mult(PolynomialGF2mSmallM.headCoefficient(result[1]), hc)};
            int[] q = this.multWithElement(f, coeff[0]);
            int n = PolynomialGF2mSmallM.computeDegree(result[1]) - df;
            q = PolynomialGF2mSmallM.multWithMonomial(q, n);
            coeff = PolynomialGF2mSmallM.multWithMonomial(coeff, n);
            result[0] = this.add(coeff, result[0]);
            result[1] = this.add(q, result[1]);
        }
        return result;
    }

    public PolynomialGF2mSmallM gcd(PolynomialGF2mSmallM f) {
        int[] resultCoeff = this.gcd(this.coefficients, f.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] gcd(int[] f, int[] g) {
        int[] a = f;
        int[] b = g;
        if (PolynomialGF2mSmallM.computeDegree(a) == -1) {
            return b;
        }
        while (PolynomialGF2mSmallM.computeDegree(b) != -1) {
            int[] c = this.mod(a, b);
            a = new int[b.length];
            System.arraycopy(b, 0, a, 0, a.length);
            b = new int[c.length];
            System.arraycopy(c, 0, b, 0, b.length);
        }
        int coeff = this.field.inverse(PolynomialGF2mSmallM.headCoefficient(a));
        return this.multWithElement(a, coeff);
    }

    public PolynomialGF2mSmallM multiply(PolynomialGF2mSmallM factor) {
        int[] resultCoeff = this.multiply(this.coefficients, factor.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] multiply(int[] a, int[] b) {
        int[] mult2;
        int[] mult1;
        if (PolynomialGF2mSmallM.computeDegree(a) < PolynomialGF2mSmallM.computeDegree(b)) {
            mult1 = b;
            mult2 = a;
        } else {
            mult1 = a;
            mult2 = b;
        }
        mult1 = PolynomialGF2mSmallM.normalForm(mult1);
        mult2 = PolynomialGF2mSmallM.normalForm(mult2);
        if (mult2.length == 1) {
            return this.multWithElement(mult1, mult2[0]);
        }
        int d1 = mult1.length;
        int d2 = mult2.length;
        int[] result = new int[d1 + d2 - 1];
        if (d2 != d1) {
            int[] res1 = new int[d2];
            int[] res2 = new int[d1 - d2];
            System.arraycopy(mult1, 0, res1, 0, res1.length);
            System.arraycopy(mult1, d2, res2, 0, res2.length);
            res1 = this.multiply(res1, mult2);
            res2 = this.multiply(res2, mult2);
            res2 = PolynomialGF2mSmallM.multWithMonomial(res2, d2);
            result = this.add(res1, res2);
        } else {
            d2 = d1 + 1 >>> 1;
            int d = d1 - d2;
            int[] firstPartMult1 = new int[d2];
            int[] firstPartMult2 = new int[d2];
            int[] secondPartMult1 = new int[d];
            int[] secondPartMult2 = new int[d];
            System.arraycopy(mult1, 0, firstPartMult1, 0, firstPartMult1.length);
            System.arraycopy(mult1, d2, secondPartMult1, 0, secondPartMult1.length);
            System.arraycopy(mult2, 0, firstPartMult2, 0, firstPartMult2.length);
            System.arraycopy(mult2, d2, secondPartMult2, 0, secondPartMult2.length);
            int[] helpPoly1 = this.add(firstPartMult1, secondPartMult1);
            int[] helpPoly2 = this.add(firstPartMult2, secondPartMult2);
            int[] res1 = this.multiply(firstPartMult1, firstPartMult2);
            int[] res2 = this.multiply(helpPoly1, helpPoly2);
            int[] res3 = this.multiply(secondPartMult1, secondPartMult2);
            res2 = this.add(res2, res1);
            res2 = this.add(res2, res3);
            res3 = PolynomialGF2mSmallM.multWithMonomial(res3, d2);
            result = this.add(res2, res3);
            result = PolynomialGF2mSmallM.multWithMonomial(result, d2);
            result = this.add(result, res1);
        }
        return result;
    }

    private boolean isIrreducible(int[] a) {
        if (a[0] == 0) {
            return false;
        }
        int d = PolynomialGF2mSmallM.computeDegree(a) >> 1;
        int[] u = new int[]{0, 1};
        int[] Y = new int[]{0, 1};
        int fieldDegree = this.field.getDegree();
        for (int i = 0; i < d; ++i) {
            for (int j = fieldDegree - 1; j >= 0; --j) {
                u = this.modMultiply(u, u, a);
            }
            int[] g = this.gcd(this.add(u = PolynomialGF2mSmallM.normalForm(u), Y), a);
            if (PolynomialGF2mSmallM.computeDegree(g) == 0) continue;
            return false;
        }
        return true;
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM f) {
        int[] resultCoeff = this.mod(this.coefficients, f.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] mod(int[] a, int[] f) {
        int df = PolynomialGF2mSmallM.computeDegree(f);
        if (df == -1) {
            throw new ArithmeticException("Division by zero");
        }
        int[] result = new int[a.length];
        int hc = PolynomialGF2mSmallM.headCoefficient(f);
        hc = this.field.inverse(hc);
        System.arraycopy(a, 0, result, 0, result.length);
        while (df <= PolynomialGF2mSmallM.computeDegree(result)) {
            int coeff = this.field.mult(PolynomialGF2mSmallM.headCoefficient(result), hc);
            int[] q = PolynomialGF2mSmallM.multWithMonomial(f, PolynomialGF2mSmallM.computeDegree(result) - df);
            q = this.multWithElement(q, coeff);
            result = this.add(q, result);
        }
        return result;
    }

    public PolynomialGF2mSmallM modMultiply(PolynomialGF2mSmallM a, PolynomialGF2mSmallM b) {
        int[] resultCoeff = this.modMultiply(this.coefficients, a.coefficients, b.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modSquareMatrix(PolynomialGF2mSmallM[] matrix) {
        int i;
        int length = matrix.length;
        int[] resultCoeff = new int[length];
        int[] thisSquare = new int[length];
        for (i = 0; i < this.coefficients.length; ++i) {
            thisSquare[i] = this.field.mult(this.coefficients[i], this.coefficients[i]);
        }
        for (i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                if (i >= matrix[j].coefficients.length) continue;
                int scalarTerm = this.field.mult(matrix[j].coefficients[i], thisSquare[j]);
                resultCoeff[i] = this.field.add(resultCoeff[i], scalarTerm);
            }
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] modMultiply(int[] a, int[] b, int[] g) {
        return this.mod(this.multiply(a, b), g);
    }

    public PolynomialGF2mSmallM modSquareRoot(PolynomialGF2mSmallM a) {
        int[] resultCoeff = IntUtils.clone(this.coefficients);
        int[] help = this.modMultiply(resultCoeff, resultCoeff, a.coefficients);
        while (!PolynomialGF2mSmallM.isEqual(help, this.coefficients)) {
            resultCoeff = PolynomialGF2mSmallM.normalForm(help);
            help = this.modMultiply(resultCoeff, resultCoeff, a.coefficients);
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modSquareRootMatrix(PolynomialGF2mSmallM[] matrix) {
        int i;
        int length = matrix.length;
        int[] resultCoeff = new int[length];
        for (i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                if (i >= matrix[j].coefficients.length || j >= this.coefficients.length) continue;
                int scalarTerm = this.field.mult(matrix[j].coefficients[i], this.coefficients[j]);
                resultCoeff[i] = this.field.add(resultCoeff[i], scalarTerm);
            }
        }
        for (i = 0; i < length; ++i) {
            resultCoeff[i] = this.field.sqRoot(resultCoeff[i]);
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modDiv(PolynomialGF2mSmallM divisor, PolynomialGF2mSmallM modulus) {
        int[] resultCoeff = this.modDiv(this.coefficients, divisor.coefficients, modulus.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] modDiv(int[] a, int[] b, int[] g) {
        int[] r0 = PolynomialGF2mSmallM.normalForm(g);
        int[] r1 = this.mod(b, g);
        int[] s0 = new int[]{0};
        int[] s1 = this.mod(a, g);
        while (PolynomialGF2mSmallM.computeDegree(r1) != -1) {
            int[][] q = this.div(r0, r1);
            r0 = PolynomialGF2mSmallM.normalForm(r1);
            r1 = PolynomialGF2mSmallM.normalForm(q[1]);
            int[] s2 = this.add(s0, this.modMultiply(q[0], s1, g));
            s0 = PolynomialGF2mSmallM.normalForm(s1);
            s1 = PolynomialGF2mSmallM.normalForm(s2);
        }
        int hc = PolynomialGF2mSmallM.headCoefficient(r0);
        s0 = this.multWithElement(s0, this.field.inverse(hc));
        return s0;
    }

    public PolynomialGF2mSmallM modInverse(PolynomialGF2mSmallM a) {
        int[] unit = new int[]{1};
        int[] resultCoeff = this.modDiv(unit, this.coefficients, a.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM[] modPolynomialToFracton(PolynomialGF2mSmallM g) {
        int dg = g.degree >> 1;
        int[] a0 = PolynomialGF2mSmallM.normalForm(g.coefficients);
        int[] a1 = this.mod(this.coefficients, g.coefficients);
        int[] b0 = new int[]{0};
        int[] b1 = new int[]{1};
        while (PolynomialGF2mSmallM.computeDegree(a1) > dg) {
            int[][] q = this.div(a0, a1);
            a0 = a1;
            a1 = q[1];
            int[] b2 = this.add(b0, this.modMultiply(q[0], b1, g.coefficients));
            b0 = b1;
            b1 = b2;
        }
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.field, a1), new PolynomialGF2mSmallM(this.field, b1)};
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PolynomialGF2mSmallM)) {
            return false;
        }
        PolynomialGF2mSmallM p = (PolynomialGF2mSmallM)other;
        return this.field.equals(p.field) && this.degree == p.degree && PolynomialGF2mSmallM.isEqual(this.coefficients, p.coefficients);
    }

    private static boolean isEqual(int[] a, int[] b) {
        int db;
        int da = PolynomialGF2mSmallM.computeDegree(a);
        if (da != (db = PolynomialGF2mSmallM.computeDegree(b))) {
            return false;
        }
        for (int i = 0; i <= da; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.field.hashCode();
        for (int j = 0; j < this.coefficients.length; ++j) {
            hash = hash * 31 + this.coefficients[j];
        }
        return hash;
    }

    public String toString() {
        String str = " Polynomial over " + this.field.toString() + ": \n";
        for (int i = 0; i < this.coefficients.length; ++i) {
            str = str + this.field.elementToStr(this.coefficients[i]) + "Y^" + i + "+";
        }
        str = str + ";";
        return str;
    }

    private void computeDegree() {
        this.degree = this.coefficients.length - 1;
        while (this.degree >= 0 && this.coefficients[this.degree] == 0) {
            --this.degree;
        }
    }

    private static int computeDegree(int[] a) {
        int degree;
        for (degree = a.length - 1; degree >= 0 && a[degree] == 0; --degree) {
        }
        return degree;
    }

    private static int[] normalForm(int[] a) {
        int d = PolynomialGF2mSmallM.computeDegree(a);
        if (d == -1) {
            return new int[1];
        }
        if (a.length == d + 1) {
            return IntUtils.clone(a);
        }
        int[] result = new int[d + 1];
        System.arraycopy(a, 0, result, 0, d + 1);
        return result;
    }
}

