/*
 * Decompiled with CFR 0.152.
 */
package smartcontracts;

import com.icodici.crypto.PrivateKey;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.permissions.ModifyDataPermission;
import com.icodici.universa.contract.permissions.RevokePermission;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import net.sergeych.tools.Binder;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.runtime.BoxesRunTime;
import smartcontracts.Account;
import universa.Logging;
import universa.MutableBiProxy;

public final class Account$
implements Logging {
    public static Account$ MODULE$;
    private final String contractTypeCode;
    private final Enumeration.Value minLogLevel;

    static {
        new Account$();
    }

    @Override
    public void log(Function0<String> text, Enumeration.Value level) {
        Logging.log$(this, text, level);
    }

    @Override
    public void debug(Function0<String> text) {
        Logging.debug$(this, text);
    }

    @Override
    public void info(Function0<String> text) {
        Logging.info$(this, text);
    }

    @Override
    public void error(Function0<String> text) {
        Logging.error$(this, text);
    }

    @Override
    public Enumeration.Value log$default$2() {
        return Logging.log$default$2$(this);
    }

    @Override
    public Enumeration.Value minLogLevel() {
        return this.minLogLevel;
    }

    @Override
    public void universa$Logging$_setter_$minLogLevel_$eq(Enumeration.Value x$1) {
        this.minLogLevel = x$1;
    }

    public String contractTypeCode() {
        return this.contractTypeCode;
    }

    /*
     * WARNING - void declaration
     */
    public Account apply(String currency, PrivateKey owner) {
        void var3_3;
        Account acc = new Account(new Contract(owner));
        MutableBiProxy d = acc.mutableDefinition();
        d.update("currency", currency);
        d.update("type", this.contractTypeCode());
        acc.state().update("blocked", BoxesRunTime.boxToBoolean(false));
        acc.contract().addPermission(new ModifyDataPermission(acc.roleLink("owner"), Binder.of("fields", JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("blocked"), null)}))).asJava(), new Object[0])));
        acc.contract().addPermission(new RevokePermission(acc.roleLink("owner")));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Account loadFrom(Path filePath) {
        void var3_3;
        byte[] packed = Files.readAllBytes(filePath);
        Account acc = new Account(new Contract(packed));
        String string = acc.typeCode();
        String string2 = this.contractTypeCode();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file contains invalid contract type: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{acc.typeCode()})));
        }
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contract loaded: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{filePath})));
        return var3_3;
    }

    private Account$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.contractTypeCode = "ALPHAMVP_ACCOUNT_CONTRACT";
    }
}

