/*
 * Decompiled with CFR 0.152.
 */
package smartcontracts;

import com.icodici.crypto.PrivateKey;
import com.icodici.crypto.PublicKey;
import com.icodici.universa.Decimal;
import com.icodici.universa.contract.Contract;
import com.icodici.universa.contract.TransactionPack;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric$BigDecimalIsFractional$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import smartcontracts.Account;
import smartcontracts.Asset$;
import universa.UContract;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001\u0015\u0011Q!Q:tKRT\u0011aA\u0001\u000fg6\f'\u000f^2p]R\u0014\u0018m\u0019;t\u0007\u0001\u0019\"\u0001\u0001\u0004\u0011\u0005\u001dQQ\"\u0001\u0005\u000b\u0003%\t\u0001\"\u001e8jm\u0016\u00148/Y\u0005\u0003\u0017!\u0011\u0011\"V\"p]R\u0014\u0018m\u0019;\t\u00135\u0001!\u0011!Q\u0001\n9A\u0012\u0001C2p]R\u0014\u0018m\u0019;\u0011\u0005=1R\"\u0001\t\u000b\u00055\t\"BA\u0005\u0013\u0015\t\u0019B#A\u0004jG>$\u0017nY5\u000b\u0003U\t1aY8n\u0013\t9\u0002C\u0001\u0005D_:$(/Y2u\u0013\ti!\u0002\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\u001d\t7mY8v]R,\u0012\u0001\b\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011q!Q2d_VtG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001d\u0003!\t7mY8v]R\u0004\u0003\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0002&M\u001d\u0002\"!\b\u0001\t\u000b5\u0011\u0003\u0019\u0001\b\t\u000bi\u0011\u0003\u0019\u0001\u000f\t\u000b%\u0002A\u0011\u0001\u0016\u0002\r\u0005lw.\u001e8u+\u0005Y\u0003C\u0001\u00177\u001d\ti3G\u0004\u0002/c5\tqF\u0003\u00021\t\u00051AH]8pizJ\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iU\nq\u0001]1dW\u0006<WMC\u00013\u0013\t9\u0004H\u0001\u0006CS\u001e$UmY5nC2T!\u0001N\u001b\t\u0011i\u0002\u0001R1A\u0005\u0002m\n\u0001bY;se\u0016t7-_\u000b\u0002yA\u0011Q(\u0011\b\u0003}}\u0002\"AL\u001b\n\u0005\u0001+\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001b\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\u0006Yql\u001c7e\u0003\u000e\u001cw.\u001e8u+\u00059\u0005c\u0001%J95\tQ'\u0003\u0002Kk\t1q\n\u001d;j_:Dq\u0001\u0014\u0001A\u0002\u0013%Q*A\b`_2$\u0017iY2pk:$x\fJ3r)\tq\u0015\u000b\u0005\u0002I\u001f&\u0011\u0001+\u000e\u0002\u0005+:LG\u000fC\u0004S\u0017\u0006\u0005\t\u0019A$\u0002\u0007a$\u0013\u0007\u0003\u0004U\u0001\u0001\u0006KaR\u0001\r?>dG-Q2d_VtG\u000f\t\u0005\u0006G\u0001!\tB\u0016\u000b\u0005K]C\u0016\fC\u0003\u000e+\u0002\u0007a\u0002C\u0003\u001b+\u0002\u0007A\u0004C\u0003[+\u0002\u0007A$\u0001\u0006pY\u0012\f5mY8v]RDQ\u0001\u0018\u0001\u0005Bu\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002y!)q\f\u0001C!A\u0006\t\u0002/Y2lK\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0016\u0003\u0005\u00042\u0001\u00132e\u0013\t\u0019WGA\u0003BeJ\f\u0017\u0010\u0005\u0002IK&\u0011a-\u000e\u0002\u0005\u0005f$X\rC\u0003i\u0001\u0011\u0005\u0011.\u0001\u0006ue\u0006t7OZ3s)>$2!\n6m\u0011\u0015Yw\r1\u0001\u001d\u0003)qWm^!dG>,h\u000e\u001e\u0005\u0006[\u001e\u0004\rA\\\u0001\t_^tWM]&fsB\u0011qN]\u0007\u0002a*\u0011\u0011OE\u0001\u0007GJL\b\u000f^8\n\u0005M\u0004(A\u0003)sSZ\fG/Z&fs\")Q\u000f\u0001C\u0001m\u0006iQ\r\u001f;sC\u000e$\u0018)\\8v]R$Ba\u001e>}{B!\u0001\n_\u0013&\u0013\tIXG\u0001\u0004UkBdWM\r\u0005\u0006wR\u0004\raK\u0001\u0010C6|WO\u001c;U_\u0016CHO]1di\")Q\u000e\u001ea\u0001]\")a\u0010\u001ea\u0001\u007f\u00061am\u001c:LKf\u00042a\\A\u0001\u0013\r\t\u0019\u0001\u001d\u0002\n!V\u0014G.[2LKfDq!a\u0002\u0001\t\u0003\tI!\u0001\u0003k_&tG\u0003BA\u0006\u0003/!2!JA\u0007\u0011!\ty!!\u0002A\u0002\u0005E\u0011\u0001B6fsN\u0004B\u0001SA\n]&\u0019\u0011QC\u001b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0003\u0005\u0002\u001a\u0005\u0015\u0001\u0019AA\u000e\u0003\u0015\u0001\u0018M\u001d;t!\u0011A\u00151C\u0013\b\u000f\u0005}!\u0001#\u0001\u0002\"\u0005)\u0011i]:fiB\u0019Q$a\t\u0007\r\u0005\u0011\u0001\u0012AA\u0013'\u0011\t\u0019#a\n\u0011\u0007!\u000bI#C\u0002\u0002,U\u0012a!\u00118z%\u00164\u0007bB\u0012\u0002$\u0011\u0005\u0011q\u0006\u000b\u0003\u0003CA\u0001\"a\r\u0002$\u0011\u0005\u0011QG\u0001\u0006CB\u0004H.\u001f\u000b\bK\u0005]\u00121HA\u001f\u0011\u001d\tI$!\rA\u0002-\nQA^1mk\u0016DaAGA\u0019\u0001\u0004a\u0002bBA \u0003c\u0001\rA\\\u0001\nSN\u001cX/\u001a:LKfD!\"a\u0011\u0002$\t\u0007I\u0011AA#\u0003\r\tG\u000e\\\u000b\u0003\u0003\u000f\u0002R!!\u0013\u0002T\u0015j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\b[V$\u0018M\u00197f\u0015\r\t\t&N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA+\u0003\u0017\u00121aU3u\u0011%\tI&a\t!\u0002\u0013\t9%\u0001\u0003bY2\u0004\u0003")
public class Asset
extends UContract {
    private String currency;
    private final Account account;
    private Option<Account> _oldAccount;
    private volatile boolean bitmap$0;

    public static Set<Asset> all() {
        return Asset$.MODULE$.all();
    }

    public Account account() {
        return this.account;
    }

    public BigDecimal amount() {
        return package$.MODULE$.BigDecimal().apply(this.state().apply("amount").toString());
    }

    private String currency$lzycompute() {
        Asset asset = this;
        synchronized (asset) {
            if (!this.bitmap$0) {
                this.currency = (String)this.definition().apply("currency");
                this.bitmap$0 = true;
            }
        }
        return this.currency;
    }

    public String currency() {
        return !this.bitmap$0 ? this.currency$lzycompute() : this.currency;
    }

    private Option<Account> _oldAccount() {
        return this._oldAccount;
    }

    private void _oldAccount_$eq(Option<Account> x$1) {
        this._oldAccount = x$1;
    }

    public String toString() {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asset(", " ", " [", "])"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.amount(), this.currency(), this.optId()}));
    }

    @Override
    public byte[] packedTransaction() {
        super.contract().seal();
        TransactionPack tp = new TransactionPack(super.contract());
        tp.addReferencedItem(this.account().contract());
        this._oldAccount().foreach((Function1<Account, Object> & Serializable & scala.Serializable)acc -> {
            tp.addReferencedItem(acc.contract());
            return BoxedUnit.UNIT;
        });
        return tp.pack();
    }

    /*
     * WARNING - void declaration
     */
    public Asset transferTo(Account newAccount, PrivateKey ownerKey) {
        void var3_3;
        Asset asset = new Asset(super.contract().createRevision(ownerKey), newAccount, this.account());
        asset.state().update("account_origin", newAccount.origin().toBase64String());
        return var3_3;
    }

    public Tuple2<Asset, Asset> extractAmount(BigDecimal amountToExtract, PrivateKey ownerKey, PublicKey forKey) {
        if (amountToExtract.$less$eq(BigDecimal$.MODULE$.int2bigDecimal(0)) || amountToExtract.$greater(this.amount())) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"can't extract ", " from ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{amountToExtract, this.toString()})));
        }
        Contract c1 = super.contract().createRevision(ownerKey);
        Contract c2 = c1.splitValue("amount", new Decimal(amountToExtract.toString()));
        c2.setOwnerKey(forKey);
        c2.seal();
        c1.seal();
        return new Tuple2<Asset, Asset>(new Asset(c1, this.account()), new Asset(c2, this.account()));
    }

    public Asset join(Seq<Asset> parts, Seq<PrivateKey> keys) {
        Contract result = super.contract().createRevision((PrivateKey[])keys.toArray(ClassTag$.MODULE$.apply(PrivateKey.class)));
        result.addRevokingItems((Contract[])((TraversableOnce)parts.map((Function1<Asset, Contract> & Serializable & scala.Serializable)x$1 -> x$1.contract(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Contract.class)));
        result.getStateData().set("amount", this.amount().$plus(((TraversableOnce)parts.map((Function1<Asset, BigDecimal> & Serializable & scala.Serializable)x$2 -> x$2.amount(), Seq$.MODULE$.canBuildFrom())).sum(Numeric$BigDecimalIsFractional$.MODULE$)));
        result.seal();
        return new Asset(result, this.account());
    }

    public Asset(Contract contract, Account account) {
        this.account = account;
        super(contract);
        Asset$.MODULE$.all().$plus$eq(this);
        this._oldAccount = Option$.MODULE$.empty();
    }

    public Asset(Contract contract, Account account, Account oldAccount) {
        this(contract, account);
        this._oldAccount_$eq(new Some<Account>(oldAccount));
    }
}

